/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.mongodb.MongoCommandException;
import com.dre.brewery.depend.mongodb.MongoNamespace;
import com.dre.brewery.depend.mongodb.internal.async.SingleResultCallback;
import com.dre.brewery.depend.mongodb.internal.binding.AsyncWriteBinding;
import com.dre.brewery.depend.mongodb.internal.binding.WriteBinding;
import com.dre.brewery.depend.mongodb.internal.operation.AsyncOperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.AsyncWriteOperation;
import com.dre.brewery.depend.mongodb.internal.operation.SyncOperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.WriteOperation;
import com.dre.brewery.depend.mongodb.lang.Nullable;

abstract class AbstractWriteSearchIndexOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace namespace;

    AbstractWriteSearchIndexOperation(MongoNamespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return SyncOperationHelper.withConnection(binding, connection -> {
            try {
                SyncOperationHelper.executeCommand(binding, this.namespace.getDatabaseName(), this.buildCommand(), connection, SyncOperationHelper.writeConcernErrorTransformer(binding.getOperationContext().getTimeoutContext()));
            }
            catch (MongoCommandException mongoCommandException) {
                this.swallowOrThrow(mongoCommandException);
            }
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        AsyncOperationHelper.withAsyncSourceAndConnection(binding::getWriteConnectionSource, false, callback, (connectionSource, connection, cb) -> AsyncOperationHelper.executeCommandAsync(binding, this.namespace.getDatabaseName(), this.buildCommand(), connection, AsyncOperationHelper.writeConcernErrorTransformerAsync(binding.getOperationContext().getTimeoutContext()), (result, commandExecutionError) -> {
            try {
                this.swallowOrThrow(commandExecutionError);
                callback.onResult((Void)result, null);
            }
            catch (Throwable mongoCommandException) {
                callback.onResult(null, mongoCommandException);
            }
        }));
    }

    <E extends Throwable> void swallowOrThrow(@Nullable E mongoExecutionException) throws E {
        if (mongoExecutionException != null) {
            throw mongoExecutionException;
        }
    }

    abstract BsonDocument buildCommand();

    MongoNamespace getNamespace() {
        return this.namespace;
    }
}

