/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.mongodb.MongoInternalException;
import com.dre.brewery.depend.mongodb.connection.SslSettings;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

public final class SslHelper {
    public static void enableHostNameVerification(SSLParameters sslParameters) {
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
    }

    public static void enableSni(String host, SSLParameters sslParameters) {
        try {
            SNIHostName sniHostName = new SNIHostName(host);
            sslParameters.setServerNames(Collections.singletonList(sniHostName));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void configureSslSocket(Socket socket, SslSettings sslSettings, InetSocketAddress inetSocketAddress) throws MongoInternalException {
        if (sslSettings.isEnabled() || socket instanceof SSLSocket) {
            if (!(socket instanceof SSLSocket)) {
                throw new MongoInternalException("SSL is enabled but the socket is not an instance of javax.net.ssl.SSLSocket");
            }
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLParameters sslParameters = sslSocket.getSSLParameters();
            if (sslParameters == null) {
                sslParameters = new SSLParameters();
            }
            SslHelper.enableSni(inetSocketAddress.getHostName(), sslParameters);
            if (!sslSettings.isInvalidHostNameAllowed()) {
                SslHelper.enableHostNameVerification(sslParameters);
            }
            sslSocket.setSSLParameters(sslParameters);
        }
    }

    private SslHelper() {
    }
}

