/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.mongodb.LoggerSettings;
import com.dre.brewery.depend.mongodb.MongoCompressor;
import com.dre.brewery.depend.mongodb.MongoCredential;
import com.dre.brewery.depend.mongodb.MongoDriverInformation;
import com.dre.brewery.depend.mongodb.ServerAddress;
import com.dre.brewery.depend.mongodb.ServerApi;
import com.dre.brewery.depend.mongodb.annotations.ThreadSafe;
import com.dre.brewery.depend.mongodb.connection.ClusterConnectionMode;
import com.dre.brewery.depend.mongodb.connection.ConnectionPoolSettings;
import com.dre.brewery.depend.mongodb.connection.ServerId;
import com.dre.brewery.depend.mongodb.connection.ServerSettings;
import com.dre.brewery.depend.mongodb.event.CommandListener;
import com.dre.brewery.depend.mongodb.internal.connection.Cluster;
import com.dre.brewery.depend.mongodb.internal.connection.ClusterableServer;
import com.dre.brewery.depend.mongodb.internal.connection.ClusterableServerFactory;
import com.dre.brewery.depend.mongodb.internal.connection.DefaultConnectionFactory;
import com.dre.brewery.depend.mongodb.internal.connection.DefaultConnectionPool;
import com.dre.brewery.depend.mongodb.internal.connection.InternalConnectionPoolSettings;
import com.dre.brewery.depend.mongodb.internal.connection.InternalOperationContextFactory;
import com.dre.brewery.depend.mongodb.internal.connection.InternalStreamConnectionFactory;
import com.dre.brewery.depend.mongodb.internal.connection.LoadBalancedServer;
import com.dre.brewery.depend.mongodb.internal.connection.MongoCredentialWithCache;
import com.dre.brewery.depend.mongodb.internal.connection.StreamFactory;
import com.dre.brewery.depend.mongodb.internal.event.EventListenerHelper;
import com.dre.brewery.depend.mongodb.internal.inject.EmptyProvider;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.List;

@ThreadSafe
public class LoadBalancedClusterableServerFactory
implements ClusterableServerFactory {
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final InternalConnectionPoolSettings internalConnectionPoolSettings;
    private final StreamFactory streamFactory;
    private final MongoCredentialWithCache credential;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;
    private final ServerApi serverApi;
    private final InternalOperationContextFactory operationContextFactory;

    public LoadBalancedClusterableServerFactory(ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, StreamFactory streamFactory, @Nullable MongoCredential credential, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable String applicationName, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, @Nullable ServerApi serverApi, InternalOperationContextFactory operationContextFactory) {
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.internalConnectionPoolSettings = internalConnectionPoolSettings;
        this.streamFactory = streamFactory;
        this.credential = credential == null ? null : new MongoCredentialWithCache(credential);
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.applicationName = applicationName;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = compressorList;
        this.serverApi = serverApi;
        this.operationContextFactory = operationContextFactory;
    }

    @Override
    public ClusterableServer create(Cluster cluster, ServerAddress serverAddress) {
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(new ServerId(cluster.getClusterId(), serverAddress), new InternalStreamConnectionFactory(ClusterConnectionMode.LOAD_BALANCED, this.streamFactory, this.credential, this.applicationName, this.mongoDriverInformation, this.compressorList, this.loggerSettings, this.commandListener, this.serverApi), this.connectionPoolSettings, this.internalConnectionPoolSettings, EmptyProvider.instance(), this.operationContextFactory);
        connectionPool.ready();
        return new LoadBalancedServer(new ServerId(cluster.getClusterId(), serverAddress), connectionPool, new DefaultConnectionFactory(), EventListenerHelper.singleServerListener(this.serverSettings), cluster.getClock());
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

