/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.mongodb.AuthenticationMechanism;
import com.dre.brewery.depend.mongodb.LoggerSettings;
import com.dre.brewery.depend.mongodb.MongoCompressor;
import com.dre.brewery.depend.mongodb.MongoDriverInformation;
import com.dre.brewery.depend.mongodb.ServerApi;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ClusterConnectionMode;
import com.dre.brewery.depend.mongodb.connection.ServerId;
import com.dre.brewery.depend.mongodb.event.CommandListener;
import com.dre.brewery.depend.mongodb.internal.connection.Authenticator;
import com.dre.brewery.depend.mongodb.internal.connection.AwsAuthenticator;
import com.dre.brewery.depend.mongodb.internal.connection.ClientMetadataHelper;
import com.dre.brewery.depend.mongodb.internal.connection.ConnectionGenerationSupplier;
import com.dre.brewery.depend.mongodb.internal.connection.DefaultAuthenticator;
import com.dre.brewery.depend.mongodb.internal.connection.GSSAPIAuthenticator;
import com.dre.brewery.depend.mongodb.internal.connection.InternalConnection;
import com.dre.brewery.depend.mongodb.internal.connection.InternalConnectionFactory;
import com.dre.brewery.depend.mongodb.internal.connection.InternalStreamConnection;
import com.dre.brewery.depend.mongodb.internal.connection.InternalStreamConnectionInitializer;
import com.dre.brewery.depend.mongodb.internal.connection.MongoCredentialWithCache;
import com.dre.brewery.depend.mongodb.internal.connection.OidcAuthenticator;
import com.dre.brewery.depend.mongodb.internal.connection.PlainAuthenticator;
import com.dre.brewery.depend.mongodb.internal.connection.ScramShaAuthenticator;
import com.dre.brewery.depend.mongodb.internal.connection.StreamFactory;
import com.dre.brewery.depend.mongodb.internal.connection.X509Authenticator;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.List;

class InternalStreamConnectionFactory
implements InternalConnectionFactory {
    private final ClusterConnectionMode clusterConnectionMode;
    private final boolean isMonitoringConnection;
    private final StreamFactory streamFactory;
    private final BsonDocument clientMetadataDocument;
    private final List<MongoCompressor> compressorList;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    @Nullable
    private final ServerApi serverApi;
    private final MongoCredentialWithCache credential;

    InternalStreamConnectionFactory(ClusterConnectionMode clusterConnectionMode, StreamFactory streamFactory, @Nullable MongoCredentialWithCache credential, @Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable ServerApi serverApi) {
        this(clusterConnectionMode, false, streamFactory, credential, applicationName, mongoDriverInformation, compressorList, loggerSettings, commandListener, serverApi);
    }

    InternalStreamConnectionFactory(ClusterConnectionMode clusterConnectionMode, boolean isMonitoringConnection, StreamFactory streamFactory, @Nullable MongoCredentialWithCache credential, @Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable ServerApi serverApi) {
        this.clusterConnectionMode = clusterConnectionMode;
        this.isMonitoringConnection = isMonitoringConnection;
        this.streamFactory = Assertions.notNull("streamFactory", streamFactory);
        this.compressorList = Assertions.notNull("compressorList", compressorList);
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.serverApi = serverApi;
        this.clientMetadataDocument = ClientMetadataHelper.createClientMetadataDocument(applicationName, mongoDriverInformation);
        this.credential = credential;
    }

    @Override
    public InternalConnection create(ServerId serverId, ConnectionGenerationSupplier connectionGenerationSupplier) {
        Authenticator authenticator = this.credential == null ? null : this.createAuthenticator(this.credential);
        InternalStreamConnectionInitializer connectionInitializer = new InternalStreamConnectionInitializer(this.clusterConnectionMode, authenticator, this.clientMetadataDocument, this.compressorList, this.serverApi);
        return new InternalStreamConnection(this.clusterConnectionMode, authenticator, this.isMonitoringConnection, serverId, connectionGenerationSupplier, this.streamFactory, this.compressorList, this.loggerSettings, this.commandListener, connectionInitializer);
    }

    private Authenticator createAuthenticator(MongoCredentialWithCache credential) {
        AuthenticationMechanism authenticationMechanism = credential.getAuthenticationMechanism();
        if (authenticationMechanism == null) {
            return new DefaultAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
        }
        switch (authenticationMechanism) {
            case GSSAPI: {
                return new GSSAPIAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case PLAIN: {
                return new PlainAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case MONGODB_X509: {
                return new X509Authenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case SCRAM_SHA_1: 
            case SCRAM_SHA_256: {
                return new ScramShaAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case MONGODB_AWS: {
                return new AwsAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case MONGODB_OIDC: {
                return new OidcAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
        }
        throw new IllegalArgumentException("Unsupported authentication mechanism " + (Object)((Object)authenticationMechanism));
    }
}

