/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.FieldNameValidator;
import com.dre.brewery.depend.bson.codecs.Decoder;
import com.dre.brewery.depend.mongodb.ReadPreference;
import com.dre.brewery.depend.mongodb.connection.ClusterConnectionMode;
import com.dre.brewery.depend.mongodb.connection.ConnectionDescription;
import com.dre.brewery.depend.mongodb.internal.async.ErrorHandlingResultCallback;
import com.dre.brewery.depend.mongodb.internal.async.SingleResultCallback;
import com.dre.brewery.depend.mongodb.internal.connection.AbstractReferenceCounted;
import com.dre.brewery.depend.mongodb.internal.connection.AsyncConnection;
import com.dre.brewery.depend.mongodb.internal.connection.CommandProtocol;
import com.dre.brewery.depend.mongodb.internal.connection.CommandProtocolImpl;
import com.dre.brewery.depend.mongodb.internal.connection.Connection;
import com.dre.brewery.depend.mongodb.internal.connection.InternalConnection;
import com.dre.brewery.depend.mongodb.internal.connection.OperationContext;
import com.dre.brewery.depend.mongodb.internal.connection.ProtocolExecutor;
import com.dre.brewery.depend.mongodb.internal.connection.SplittablePayload;
import com.dre.brewery.depend.mongodb.internal.diagnostics.logging.Logger;
import com.dre.brewery.depend.mongodb.internal.diagnostics.logging.Loggers;
import com.dre.brewery.depend.mongodb.internal.session.SessionContext;
import com.dre.brewery.depend.mongodb.lang.Nullable;

public class DefaultServerConnection
extends AbstractReferenceCounted
implements Connection,
AsyncConnection {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final InternalConnection wrapped;
    private final ProtocolExecutor protocolExecutor;
    private final ClusterConnectionMode clusterConnectionMode;

    public DefaultServerConnection(InternalConnection wrapped, ProtocolExecutor protocolExecutor, ClusterConnectionMode clusterConnectionMode) {
        this.wrapped = wrapped;
        this.protocolExecutor = protocolExecutor;
        this.clusterConnectionMode = clusterConnectionMode;
    }

    @Override
    public DefaultServerConnection retain() {
        super.retain();
        return this;
    }

    @Override
    public int release() {
        int count = super.release();
        if (count == 0) {
            this.wrapped.close();
        }
        return count;
    }

    @Override
    public ConnectionDescription getDescription() {
        return this.wrapped.getDescription();
    }

    @Override
    @Nullable
    public <T> T command(String database, BsonDocument command, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, OperationContext operationContext) {
        return this.command(database, command, fieldNameValidator, readPreference, commandResultDecoder, operationContext, true, null, null);
    }

    @Override
    @Nullable
    public <T> T command(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, OperationContext operationContext, boolean responseExpected, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator) {
        return this.executeProtocol(new CommandProtocolImpl<T>(database, command, commandFieldNameValidator, readPreference, commandResultDecoder, responseExpected, payload, payloadFieldNameValidator, this.clusterConnectionMode, operationContext), operationContext.getSessionContext());
    }

    @Override
    public <T> void commandAsync(String database, BsonDocument command, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, OperationContext operationContext, SingleResultCallback<T> callback) {
        this.commandAsync(database, command, fieldNameValidator, readPreference, commandResultDecoder, operationContext, true, null, null, callback);
    }

    @Override
    public <T> void commandAsync(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, OperationContext operationContext, boolean responseExpected, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator, SingleResultCallback<T> callback) {
        this.executeProtocolAsync(new CommandProtocolImpl<T>(database, command, commandFieldNameValidator, readPreference, commandResultDecoder, responseExpected, payload, payloadFieldNameValidator, this.clusterConnectionMode, operationContext), operationContext.getSessionContext(), callback);
    }

    @Override
    public void markAsPinned(Connection.PinningMode pinningMode) {
        this.wrapped.markAsPinned(pinningMode);
    }

    @Nullable
    private <T> T executeProtocol(CommandProtocol<T> protocol, SessionContext sessionContext) {
        return this.protocolExecutor.execute(protocol, this.wrapped, sessionContext);
    }

    private <T> void executeProtocolAsync(CommandProtocol<T> protocol, SessionContext sessionContext, SingleResultCallback<T> callback) {
        SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        try {
            this.protocolExecutor.executeAsync(protocol, this.wrapped, sessionContext, errHandlingCallback);
        }
        catch (Throwable t) {
            errHandlingCallback.onResult(null, t);
        }
    }
}

