/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.bson.BsonBinaryReader;
import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonType;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.bson.ByteBuf;
import com.dre.brewery.depend.bson.RawBsonDocument;
import com.dre.brewery.depend.bson.codecs.BsonDocumentCodec;
import com.dre.brewery.depend.bson.codecs.DecoderContext;
import com.dre.brewery.depend.bson.io.ByteBufferBsonInput;
import com.dre.brewery.depend.bson.json.JsonMode;
import com.dre.brewery.depend.bson.json.JsonWriter;
import com.dre.brewery.depend.bson.json.JsonWriterSettings;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.internal.connection.ByteBufBsonHelper;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.StringWriter;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

final class ByteBufBsonDocument
extends BsonDocument {
    private static final long serialVersionUID = 2L;
    private final transient ByteBuf byteBuf;

    static List<ByteBufBsonDocument> createList(ByteBuf outputByteBuf) {
        ArrayList<ByteBufBsonDocument> documents = new ArrayList<ByteBufBsonDocument>();
        while (outputByteBuf.hasRemaining()) {
            ByteBufBsonDocument curDocument = ByteBufBsonDocument.createOne(outputByteBuf);
            documents.add(curDocument);
        }
        return documents;
    }

    static ByteBufBsonDocument createOne(ByteBuf outputByteBuf) {
        int documentStart = outputByteBuf.position();
        int documentSizeInBytes = outputByteBuf.getInt();
        int documentEnd = documentStart + documentSizeInBytes;
        ByteBuf slice = outputByteBuf.duplicate().position(documentStart).limit(documentEnd);
        outputByteBuf.position(documentEnd);
        return new ByteBufBsonDocument(slice);
    }

    @Override
    public String toJson() {
        return this.toJson(JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build());
    }

    @Override
    public String toJson(JsonWriterSettings settings) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter(stringWriter, settings);
        ByteBuf duplicate = this.byteBuf.duplicate();
        try {
            BsonBinaryReader reader = new BsonBinaryReader(new ByteBufferBsonInput(duplicate));
            try {
                jsonWriter.pipe(reader);
                String string = stringWriter.toString();
                reader.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            duplicate.release();
        }
    }

    @Override
    public BsonBinaryReader asBsonReader() {
        return new BsonBinaryReader(new ByteBufferBsonInput(this.byteBuf.duplicate()));
    }

    @Override
    public BsonDocument clone() {
        byte[] clonedBytes = new byte[this.byteBuf.remaining()];
        this.byteBuf.get(this.byteBuf.position(), clonedBytes);
        return new RawBsonDocument(clonedBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    <T> T findInDocument(Finder<T> finder) {
        ByteBuf duplicateByteBuf = this.byteBuf.duplicate();
        try (BsonBinaryReader bsonReader = new BsonBinaryReader(new ByteBufferBsonInput(duplicateByteBuf));){
            bsonReader.readStartDocument();
            while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                T found = finder.find(duplicateByteBuf, bsonReader);
                if (found == null) continue;
                T t = found;
                return t;
            }
            bsonReader.readEndDocument();
            return finder.notFound();
        }
        finally {
            duplicateByteBuf.release();
        }
    }

    BsonDocument toBaseBsonDocument() {
        ByteBuf duplicateByteBuf = this.byteBuf.duplicate();
        try {
            BsonBinaryReader bsonReader = new BsonBinaryReader(new ByteBufferBsonInput(duplicateByteBuf));
            try {
                BsonDocument bsonDocument = new BsonDocumentCodec().decode(bsonReader, DecoderContext.builder().build());
                bsonReader.close();
                return bsonDocument;
            }
            catch (Throwable throwable) {
                try {
                    bsonReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            duplicateByteBuf.release();
        }
    }

    ByteBufBsonDocument(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    @Override
    public BsonValue put(String key, BsonValue value) {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    @Override
    public BsonDocument append(String key, BsonValue value) {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    @Override
    public void putAll(Map<? extends String, ? extends BsonValue> m) {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    @Override
    public BsonValue remove(Object key) {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    @Override
    public boolean isEmpty() {
        return Assertions.assertNotNull(this.findInDocument(new Finder<Boolean>(){

            @Override
            public Boolean find(ByteBuf byteBuf, BsonBinaryReader bsonReader) {
                return false;
            }

            @Override
            public Boolean notFound() {
                return true;
            }
        }));
    }

    @Override
    public int size() {
        return Assertions.assertNotNull(this.findInDocument(new Finder<Integer>(){
            private int size;

            @Override
            @Nullable
            public Integer find(ByteBuf byteBuf, BsonBinaryReader bsonReader) {
                ++this.size;
                bsonReader.readName();
                bsonReader.skipValue();
                return null;
            }

            @Override
            public Integer notFound() {
                return this.size;
            }
        }));
    }

    @Override
    public Set<Map.Entry<String, BsonValue>> entrySet() {
        return new ByteBufBsonDocumentEntrySet();
    }

    @Override
    public Collection<BsonValue> values() {
        return new ByteBufBsonDocumentValuesCollection();
    }

    @Override
    public Set<String> keySet() {
        return new ByteBufBsonDocumentKeySet();
    }

    @Override
    public boolean containsKey(final Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key can not be null");
        }
        Boolean containsKey = this.findInDocument(new Finder<Boolean>(){

            @Override
            public Boolean find(ByteBuf byteBuf, BsonBinaryReader bsonReader) {
                if (bsonReader.readName().equals(key)) {
                    return true;
                }
                bsonReader.skipValue();
                return null;
            }

            @Override
            public Boolean notFound() {
                return false;
            }
        });
        return containsKey != null ? containsKey : false;
    }

    @Override
    public boolean containsValue(final Object value) {
        Boolean containsValue = this.findInDocument(new Finder<Boolean>(){

            @Override
            public Boolean find(ByteBuf byteBuf, BsonBinaryReader bsonReader) {
                bsonReader.skipName();
                if (ByteBufBsonHelper.readBsonValue(byteBuf, bsonReader).equals(value)) {
                    return true;
                }
                return null;
            }

            @Override
            public Boolean notFound() {
                return false;
            }
        });
        return containsValue != null ? containsValue : false;
    }

    @Override
    @Nullable
    public BsonValue get(final Object key) {
        Assertions.notNull("key", key);
        return this.findInDocument(new Finder<BsonValue>(){

            @Override
            public BsonValue find(ByteBuf byteBuf, BsonBinaryReader bsonReader) {
                if (bsonReader.readName().equals(key)) {
                    return ByteBufBsonHelper.readBsonValue(byteBuf, bsonReader);
                }
                bsonReader.skipValue();
                return null;
            }

            @Override
            @Nullable
            public BsonValue notFound() {
                return null;
            }
        });
    }

    @Override
    public String getFirstKey() {
        return Assertions.assertNotNull(this.findInDocument(new Finder<String>(){

            @Override
            public String find(ByteBuf byteBuf, BsonBinaryReader bsonReader) {
                return bsonReader.readName();
            }

            @Override
            public String notFound() {
                throw new NoSuchElementException();
            }
        }));
    }

    private Object writeReplace() {
        return this.toBaseBsonDocument();
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static interface Finder<T> {
        @Nullable
        public T find(ByteBuf var1, BsonBinaryReader var2);

        @Nullable
        public T notFound();
    }

    private class ByteBufBsonDocumentEntrySet
    extends AbstractSet<Map.Entry<String, BsonValue>> {
        private ByteBufBsonDocumentEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, BsonValue>> iterator() {
            return new Iterator<Map.Entry<String, BsonValue>>(){
                private final ByteBuf duplicatedByteBuf;
                private final BsonBinaryReader bsonReader;
                {
                    this.duplicatedByteBuf = ByteBufBsonDocument.this.byteBuf.duplicate();
                    this.bsonReader = new BsonBinaryReader(new ByteBufferBsonInput(this.duplicatedByteBuf));
                    this.bsonReader.readStartDocument();
                    this.bsonReader.readBsonType();
                }

                @Override
                public boolean hasNext() {
                    return this.bsonReader.getCurrentBsonType() != BsonType.END_OF_DOCUMENT;
                }

                @Override
                public Map.Entry<String, BsonValue> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    String key = this.bsonReader.readName();
                    BsonValue value = ByteBufBsonHelper.readBsonValue(this.duplicatedByteBuf, this.bsonReader);
                    this.bsonReader.readBsonType();
                    return new AbstractMap.SimpleEntry<String, BsonValue>(key, value);
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            return ByteBufBsonDocument.this.size();
        }
    }

    private class ByteBufBsonDocumentValuesCollection
    extends AbstractCollection<BsonValue> {
        private final Set<Map.Entry<String, BsonValue>> entrySet;

        private ByteBufBsonDocumentValuesCollection() {
            this.entrySet = new ByteBufBsonDocumentEntrySet();
        }

        @Override
        public Iterator<BsonValue> iterator() {
            final Iterator<Map.Entry<String, BsonValue>> entrySetIterator = this.entrySet.iterator();
            return new Iterator<BsonValue>(){

                @Override
                public boolean hasNext() {
                    return entrySetIterator.hasNext();
                }

                @Override
                public BsonValue next() {
                    return (BsonValue)((Map.Entry)entrySetIterator.next()).getValue();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        @Override
        public int size() {
            return this.entrySet.size();
        }
    }

    private class ByteBufBsonDocumentKeySet
    extends AbstractSet<String> {
        private final Set<Map.Entry<String, BsonValue>> entrySet;

        private ByteBufBsonDocumentKeySet() {
            this.entrySet = new ByteBufBsonDocumentEntrySet();
        }

        @Override
        public Iterator<String> iterator() {
            final Iterator<Map.Entry<String, BsonValue>> entrySetIterator = this.entrySet.iterator();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return entrySetIterator.hasNext();
                }

                @Override
                public String next() {
                    return (String)((Map.Entry)entrySetIterator.next()).getKey();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        @Override
        public int size() {
            return this.entrySet.size();
        }
    }
}

