/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.async.function;

import com.dre.brewery.depend.mongodb.annotations.NotThreadSafe;
import com.dre.brewery.depend.mongodb.internal.async.SingleResultCallback;
import com.dre.brewery.depend.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.dre.brewery.depend.mongodb.internal.async.function.RetryState;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;

@NotThreadSafe
public final class RetryingAsyncCallbackSupplier<R>
implements AsyncCallbackSupplier<R> {
    private final RetryState state;
    private final BiPredicate<RetryState, Throwable> retryPredicate;
    private final BinaryOperator<Throwable> onAttemptFailureOperator;
    private final AsyncCallbackSupplier<R> asyncFunction;

    public RetryingAsyncCallbackSupplier(RetryState state, BinaryOperator<Throwable> onAttemptFailureOperator, BiPredicate<RetryState, Throwable> retryPredicate, AsyncCallbackSupplier<R> asyncFunction) {
        this.state = state;
        this.retryPredicate = retryPredicate;
        this.onAttemptFailureOperator = onAttemptFailureOperator;
        this.asyncFunction = asyncFunction;
    }

    public RetryingAsyncCallbackSupplier(RetryState state, BiPredicate<RetryState, Throwable> retryPredicate, AsyncCallbackSupplier<R> asyncFunction) {
        this(state, (previouslyChosenFailure, lastAttemptFailure) -> lastAttemptFailure, retryPredicate, asyncFunction);
    }

    @Override
    public void get(SingleResultCallback<R> callback) {
        this.asyncFunction.get(new RetryingCallback(callback));
    }

    @NotThreadSafe
    private class RetryingCallback
    implements SingleResultCallback<R> {
        private final SingleResultCallback<R> wrapped;

        RetryingCallback(SingleResultCallback<R> callback) {
            this.wrapped = callback;
        }

        @Override
        public void onResult(@Nullable R result, @Nullable Throwable t) {
            if (t != null) {
                try {
                    RetryingAsyncCallbackSupplier.this.state.advanceOrThrow(t, (BinaryOperator<Throwable>)RetryingAsyncCallbackSupplier.this.onAttemptFailureOperator, (BiPredicate<RetryState, Throwable>)RetryingAsyncCallbackSupplier.this.retryPredicate);
                }
                catch (Throwable failedResult) {
                    this.wrapped.onResult(null, failedResult);
                    return;
                }
                RetryingAsyncCallbackSupplier.this.asyncFunction.get(this);
            } else {
                this.wrapped.onResult(result, null);
            }
        }
    }
}

