/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.connection;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonInt64;
import com.dre.brewery.depend.bson.BsonObjectId;
import com.dre.brewery.depend.bson.types.ObjectId;
import com.dre.brewery.depend.mongodb.annotations.ThreadSafe;

@ThreadSafe
public final class TopologyVersion {
    private final ObjectId processId;
    private final long counter;

    public TopologyVersion(BsonDocument topologyVersionDocument) {
        this.processId = topologyVersionDocument.getObjectId("processId").getValue();
        this.counter = topologyVersionDocument.getInt64("counter").getValue();
    }

    public TopologyVersion(ObjectId processId, long counter) {
        this.processId = processId;
        this.counter = counter;
    }

    public ObjectId getProcessId() {
        return this.processId;
    }

    public long getCounter() {
        return this.counter;
    }

    public BsonDocument asDocument() {
        return new BsonDocument("processId", new BsonObjectId(this.processId)).append("counter", new BsonInt64(this.counter));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyVersion that = (TopologyVersion)o;
        if (this.counter != that.counter) {
            return false;
        }
        return this.processId.equals(that.processId);
    }

    public int hashCode() {
        int result = this.processId.hashCode();
        result = 31 * result + (int)(this.counter ^ this.counter >>> 32);
        return result;
    }

    public String toString() {
        return "TopologyVersion{processId=" + this.processId + ", counter=" + this.counter + '}';
    }
}

