/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.client.internal;

import com.dre.brewery.depend.mongodb.Function;
import com.dre.brewery.depend.mongodb.ReadConcern;
import com.dre.brewery.depend.mongodb.ReadPreference;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.ClientSession;
import com.dre.brewery.depend.mongodb.client.MongoCursor;
import com.dre.brewery.depend.mongodb.client.MongoIterable;
import com.dre.brewery.depend.mongodb.client.cursor.TimeoutMode;
import com.dre.brewery.depend.mongodb.client.internal.MappingIterable;
import com.dre.brewery.depend.mongodb.client.internal.MongoBatchCursorAdapter;
import com.dre.brewery.depend.mongodb.client.internal.OperationExecutor;
import com.dre.brewery.depend.mongodb.internal.TimeoutSettings;
import com.dre.brewery.depend.mongodb.internal.operation.BatchCursor;
import com.dre.brewery.depend.mongodb.internal.operation.ReadOperation;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public abstract class MongoIterableImpl<TResult>
implements MongoIterable<TResult> {
    private final ClientSession clientSession;
    private final ReadConcern readConcern;
    private final OperationExecutor executor;
    private final ReadPreference readPreference;
    private final boolean retryReads;
    private final TimeoutSettings timeoutSettings;
    private Integer batchSize;
    private TimeoutMode timeoutMode;

    public MongoIterableImpl(@Nullable ClientSession clientSession, OperationExecutor executor, ReadConcern readConcern, ReadPreference readPreference, boolean retryReads, TimeoutSettings timeoutSettings) {
        this.clientSession = clientSession;
        this.executor = Assertions.notNull("executor", executor);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.retryReads = retryReads;
        this.timeoutSettings = timeoutSettings;
    }

    public abstract ReadOperation<BatchCursor<TResult>> asReadOperation();

    @Nullable
    ClientSession getClientSession() {
        return this.clientSession;
    }

    protected abstract OperationExecutor getExecutor();

    OperationExecutor getExecutor(TimeoutSettings timeoutSettings) {
        return this.executor.withTimeoutSettings(timeoutSettings);
    }

    ReadPreference getReadPreference() {
        return this.readPreference;
    }

    protected ReadConcern getReadConcern() {
        return this.readConcern;
    }

    protected boolean getRetryReads() {
        return this.retryReads;
    }

    protected TimeoutSettings getTimeoutSettings() {
        return this.timeoutSettings;
    }

    @Nullable
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Override
    public MongoIterable<TResult> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Nullable
    public TimeoutMode getTimeoutMode() {
        return this.timeoutMode;
    }

    public MongoIterable<TResult> timeoutMode(TimeoutMode timeoutMode) {
        if (this.timeoutSettings.getTimeoutMS() == null) {
            throw new IllegalArgumentException("TimeoutMode requires timeoutMS to be set.");
        }
        this.timeoutMode = timeoutMode;
        return this;
    }

    @Override
    public MongoCursor<TResult> iterator() {
        return new MongoBatchCursorAdapter<TResult>(this.execute());
    }

    @Override
    public MongoCursor<TResult> cursor() {
        return this.iterator();
    }

    @Override
    @Nullable
    public TResult first() {
        try (Iterator cursor = this.iterator();){
            if (!cursor.hasNext()) {
                TResult TResult = null;
                return TResult;
            }
            Object TResult = cursor.next();
            return TResult;
        }
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return new MappingIterable<TResult, U>(this, mapper);
    }

    @Override
    public void forEach(Consumer<? super TResult> action) {
        try (Iterator cursor = this.iterator();){
            while (cursor.hasNext()) {
                action.accept(cursor.next());
            }
        }
    }

    @Override
    public <A extends Collection<? super TResult>> A into(A target) {
        this.forEach((Consumer<? super TResult>)((Consumer<Object>)target::add));
        return target;
    }

    private BatchCursor<TResult> execute() {
        return this.getExecutor().execute(this.asReadOperation(), this.readPreference, this.readConcern, this.clientSession);
    }

    protected long validateMaxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Long timeoutMS = this.timeoutSettings.getTimeoutMS();
        long maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        Assertions.isTrueArgument("maxAwaitTimeMS must be less than timeoutMS", timeoutMS == null || timeoutMS == 0L || timeoutMS > maxAwaitTimeMS);
        return maxAwaitTimeMS;
    }
}

