/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.bson.codecs;

import com.dre.brewery.depend.bson.BsonBinary;
import com.dre.brewery.depend.bson.BsonBinarySubType;
import com.dre.brewery.depend.bson.BsonInvalidOperationException;
import com.dre.brewery.depend.bson.BsonReader;
import com.dre.brewery.depend.bson.BsonWriter;
import com.dre.brewery.depend.bson.Int8Vector;
import com.dre.brewery.depend.bson.codecs.Codec;
import com.dre.brewery.depend.bson.codecs.DecoderContext;
import com.dre.brewery.depend.bson.codecs.EncoderContext;

final class Int8VectorCodec
implements Codec<Int8Vector> {
    Int8VectorCodec() {
    }

    @Override
    public void encode(BsonWriter writer, Int8Vector vectorToEncode, EncoderContext encoderContext) {
        writer.writeBinaryData(new BsonBinary(vectorToEncode));
    }

    @Override
    public Int8Vector decode(BsonReader reader, DecoderContext decoderContext) {
        byte subType = reader.peekBinarySubType();
        if (subType != BsonBinarySubType.VECTOR.getValue()) {
            throw new BsonInvalidOperationException("Expected vector binary subtype " + BsonBinarySubType.VECTOR.getValue() + " but found: " + subType);
        }
        return reader.readBinaryData().asBinary().asVector().asInt8Vector();
    }

    @Override
    public Class<Int8Vector> getEncoderClass() {
        return Int8Vector.class;
    }
}

