/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.bson.codecs;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonReader;
import com.dre.brewery.depend.bson.BsonWriter;
import com.dre.brewery.depend.bson.codecs.BsonDocumentCodec;
import com.dre.brewery.depend.bson.codecs.Codec;
import com.dre.brewery.depend.bson.codecs.DecoderContext;
import com.dre.brewery.depend.bson.codecs.EncoderContext;
import com.dre.brewery.depend.bson.codecs.configuration.CodecConfigurationException;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistry;
import com.dre.brewery.depend.bson.conversions.Bson;

public class BsonCodec
implements Codec<Bson> {
    private static final Codec<BsonDocument> BSON_DOCUMENT_CODEC = new BsonDocumentCodec();
    private final CodecRegistry registry;

    public BsonCodec(CodecRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Bson decode(BsonReader reader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException("The BsonCodec can only encode to Bson");
    }

    @Override
    public void encode(BsonWriter writer, Bson value, EncoderContext encoderContext) {
        try {
            BsonDocument bsonDocument = value.toBsonDocument(BsonDocument.class, this.registry);
            BSON_DOCUMENT_CODEC.encode(writer, bsonDocument, encoderContext);
        }
        catch (Exception e) {
            throw new CodecConfigurationException(String.format("Unable to encode a Bson implementation: %s", value), e);
        }
    }

    @Override
    public Class<Bson> getEncoderClass() {
        return Bson.class;
    }
}

