/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.commands.subcommands;

import com.dre.brewery.BIngredients;
import com.dre.brewery.BarrelWoodType;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.Translatable;
import com.dre.brewery.commands.SubCommand;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.recipe.BCauldronRecipe;
import com.dre.brewery.recipe.BRecipe;
import com.dre.brewery.recipe.RecipeItem;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.Logging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.OptionalInt;
import java.util.stream.Stream;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.Nullable;

public class SimulateCommand
implements SubCommand {
    @Override
    public void execute(BreweryPlugin breweryPlugin, Lang lang, CommandSender sender, String label, String[] args) {
        List<String> arguments = BUtil.splitStringKeepingQuotes(String.join((CharSequence)" ", args));
        SimulationParser parser = new SimulationParser();
        for (int i = 1; i <= arguments.size(); ++i) {
            Status status;
            if (i < arguments.size()) {
                String arg = arguments.get(i);
                status = parser.parse(arg);
            } else {
                status = parser.finish();
            }
            if (status instanceof Status.Help) {
                SimulateCommand.sendUsage(lang, sender);
                return;
            }
            if (status instanceof Status.Finished) {
                Status.Finished finished = (Status.Finished)status;
                SimulateCommand.simulate(lang, sender, finished.simulation());
                return;
            }
            if (!(status instanceof Status.Error)) continue;
            Status.Error error = (Status.Error)status;
            lang.sendEntry(sender, error.error().getTranslationKey(), error.args());
            return;
        }
        throw new AssertionError((Object)"parser.finish() must not return Status.Updated()");
    }

    private static void sendUsage(Lang lang, CommandSender sender) {
        lang.sendEntry(sender, "Etc_Usage", new Object[0]);
        lang.sendEntry(sender, "Help_Simulate", new Object[0]);
        lang.sendEntry(sender, "Help_Simulate_Options", new Object[0]);
        lang.sendEntry(sender, "Help_Simulate_Recipe", new Object[0]);
        lang.sendEntry(sender, "Help_Simulate_Cook", new Object[0]);
        lang.sendEntry(sender, "Help_Simulate_Distill", new Object[0]);
        lang.sendEntry(sender, "Help_Simulate_Age", new Object[0]);
        lang.sendEntry(sender, "Help_Simulate_Brewer", new Object[0]);
        lang.sendEntry(sender, "Help_Simulate_Player", new Object[0]);
    }

    private static void simulate(Lang lang, CommandSender sender, SimulationParameters simulation) {
        Age age;
        BIngredients ingredients = new BIngredients();
        for (RecipeItem item : simulation.ingredients()) {
            for (int i = 0; i < item.getAmount(); ++i) {
                ingredients.addGeneric(item);
            }
        }
        Logging.debugLog(String.format("simulate: ingredients=%s", ingredients));
        ItemStack item = ingredients.cook(simulation.cookedTime(), simulation.brewer());
        Brew brew = new Brew(ingredients);
        Logging.debugLog(String.format("simulate: cooked for %d minutes: %s", simulation.cookedTime(), ChatColor.stripColor((String)brew.toString())));
        if (simulation.distillRuns().isPresent()) {
            ItemMeta itemMeta = item.getItemMeta();
            if (!(itemMeta instanceof PotionMeta)) {
                lang.sendEntry(sender, "CMD_Cannot_Distill", new Object[0]);
                return;
            }
            PotionMeta meta = (PotionMeta)itemMeta;
            int distillRuns = simulation.distillRuns().getAsInt();
            for (int i = 0; i < distillRuns; ++i) {
                brew.distillSlot(item, meta);
            }
            Logging.debugLog(String.format("simulate: distilled for %d runs: %s", distillRuns, ChatColor.stripColor((String)brew.toString())));
            if (!brew.hasRecipe()) {
                lang.sendEntry(sender, "CMD_Distill_Ruined", new Object[0]);
                SimulateCommand.giveBrew(lang, sender, item, simulation.player());
                return;
            }
        }
        if ((age = simulation.age()) != null) {
            BarrelWoodType barrelType = age.barrelType();
            if (barrelType == null) {
                lang.sendEntry(sender, "Error_MissingBarrelType", new Object[0]);
                return;
            }
            brew.age(item, age.ageTime(), age.barrelType());
            Logging.debugLog(String.format("simulate: aged for %.3f years in %s barrel: %s", Float.valueOf(age.ageTime()), age.barrelType().getFormattedName(), ChatColor.stripColor((String)brew.toString())));
            if (!brew.hasRecipe()) {
                lang.sendEntry(sender, "CMD_Age_Ruined", new Object[0]);
            }
        }
        SimulateCommand.giveBrew(lang, sender, item, simulation.player());
    }

    private static void giveBrew(Lang lang, CommandSender sender, ItemStack item, @Nullable Player player) {
        if (player != null) {
            player.getInventory().addItem(new ItemStack[]{item});
        } else if (sender instanceof Player) {
            Player self = (Player)sender;
            self.getInventory().addItem(new ItemStack[]{item});
        } else {
            Brew fromItem = Brew.get(item);
            if (fromItem == null) {
                sender.sendMessage("&cCould not get brew from item");
                return;
            }
            sender.sendMessage(fromItem.toString());
        }
        lang.sendEntry(sender, "CMD_Simulated", new Object[0]);
    }

    @Override
    public List<String> tabComplete(BreweryPlugin breweryPlugin, CommandSender sender, String label, String[] args) {
        List<String> arguments = BUtil.splitStringKeepingQuotes(String.join((CharSequence)" ", args));
        SimulationParser parser = new SimulationParser();
        for (int i = 1; i <= arguments.size(); ++i) {
            String arg;
            String string = arg = arguments.size() == 1 ? args[1] : arguments.get(i);
            if (i >= arguments.size() - 1) {
                String rawLastArg = args[args.length - 1];
                if (rawLastArg.equals("\"")) {
                    return List.of();
                }
                if (rawLastArg.isBlank()) {
                    Status status = parser.parse(arg);
                    if (status instanceof Status.Help || status instanceof Status.Error) {
                        return List.of();
                    }
                    return SimulateCommand.tabComplete(parser, rawLastArg);
                }
                return SimulateCommand.tabComplete(parser, arg);
            }
            Status status = parser.parse(arg);
            if (!(status instanceof Status.Help) && !(status instanceof Status.Error)) continue;
            return List.of();
        }
        throw new AssertionError((Object)"unreachable");
    }

    @Nullable
    private static List<String> tabComplete(SimulationParser parser, String arg) {
        List<String> completions = parser.getTabCompletions();
        return completions == null ? null : (List)StringUtil.copyPartialMatches((String)arg, completions, new ArrayList());
    }

    private static List<String> getRecipeCompletions() {
        return Stream.concat(BCauldronRecipe.getAllRecipes().stream().map(BCauldronRecipe::getName), BRecipe.getAllRecipes().stream().mapMulti((recipe, consumer) -> {
            consumer.accept(recipe.getRecipeName());
            consumer.accept(recipe.getId());
        })).sorted().distinct().map(BUtil::quote).toList();
    }

    private static List<String> getIngredientCompletions() {
        return Stream.concat(BCauldronRecipe.getAllRecipes().stream().map(BCauldronRecipe::getIngredients), BRecipe.getAllRecipes().stream().map(BRecipe::getIngredients)).flatMap(Collection::stream).map(RecipeItem::toConfigStringNoAmount).sorted().distinct().map(BUtil::quote).toList();
    }

    @Override
    public String permission() {
        return "brewery.cmd.create";
    }

    @Override
    public boolean playerOnly() {
        return false;
    }

    private static class SimulationParser {
        private static final List<String> helpStrings = List.of("help", "-h", "--help");
        @Nullable
        private BRecipe recipe = null;
        private int cookedTime = -1;
        private int distillRuns = -1;
        @Nullable
        BarrelWoodType woodType = null;
        private float ageTime = Float.NaN;
        private final List<RecipeItem> ingredients = new ArrayList<RecipeItem>();
        @Nullable
        private Player brewer = null;
        @Nullable
        private Player player = null;
        private final EnumSet<Option> options = EnumSet.noneOf(Option.class);
        private State state = State.OPTIONS;
        @Nullable
        private String prevArg = null;

        private SimulationParser() {
        }

        public Status parse(String arg) {
            if (arg.isBlank()) {
                return new Status.Updated();
            }
            switch (this.state.ordinal()) {
                case 0: {
                    if (this.prevArg == null && helpStrings.contains(arg.toLowerCase(Locale.ROOT))) {
                        return new Status.Help();
                    }
                    if (!arg.startsWith("-")) {
                        if (this.prevArg == null) {
                            return new Status.Error(ErrorType.INVALID_OPTION, arg);
                        }
                        this.state = State.INGREDIENTS;
                        return this.parseIngredient(arg);
                    }
                    Option option = Option.get(arg);
                    if (option == null) {
                        return new Status.Error(ErrorType.INVALID_OPTION, arg);
                    }
                    if (!this.options.add(option)) {
                        return new Status.Error(ErrorType.DUPLICATE_OPTION, arg);
                    }
                    this.state = option.getState();
                    break;
                }
                case 1: {
                    BRecipe recipe = BRecipe.getMatching(arg);
                    if (recipe == null) {
                        return new Status.Error(ErrorType.RECIPE, arg);
                    }
                    this.recipe = recipe;
                    this.state = State.OPTIONS;
                    break;
                }
                case 2: {
                    int cookedTime = BUtil.parseInt(arg).orElse(-1);
                    if (cookedTime < 0) {
                        return new Status.Error(ErrorType.COOK, arg);
                    }
                    this.cookedTime = cookedTime;
                    this.state = State.OPTIONS;
                    break;
                }
                case 3: {
                    int distillRuns = BUtil.parseInt(arg).orElse(-1);
                    if (distillRuns <= 0) {
                        return new Status.Error(ErrorType.DISTILL_RUNS, arg);
                    }
                    this.distillRuns = distillRuns;
                    this.state = State.OPTIONS;
                    break;
                }
                case 4: {
                    BarrelWoodType woodType = BarrelWoodType.fromName(arg);
                    if (woodType == null || !woodType.isSpecific()) {
                        return new Status.Error(ErrorType.WOOD_TYPE, arg);
                    }
                    this.woodType = woodType;
                    this.state = State.AGE;
                    break;
                }
                case 5: {
                    float ageTime = BUtil.parseFloat(arg).orElse(-1.0f);
                    if (ageTime <= 0.0f) {
                        return new Status.Error(ErrorType.AGE_TIME, arg);
                    }
                    this.ageTime = ageTime;
                    this.state = State.OPTIONS;
                    break;
                }
                case 6: {
                    Player brewer = BUtil.getPlayerfromString(arg);
                    if (brewer == null) {
                        return new Status.Error(ErrorType.PLAYER, arg);
                    }
                    this.brewer = brewer;
                    this.state = State.OPTIONS;
                    break;
                }
                case 7: {
                    Player player = BUtil.getPlayerfromString(arg);
                    if (player == null) {
                        return new Status.Error(ErrorType.PLAYER, arg);
                    }
                    this.player = player;
                    this.state = State.OPTIONS;
                    break;
                }
                case 8: {
                    return this.parseIngredient(arg);
                }
            }
            return this.update(arg);
        }

        private Status parseIngredient(String arg) {
            if (BUtil.isInt(arg)) {
                String prevIngredient = this.prevArg != null ? this.prevArg : ConfigManager.getConfig(Lang.class).getEntry("CMD_Ingredient", new Object[0]);
                return new Status.Error(ErrorType.INVALID_INGREDIENT, arg, prevIngredient);
            }
            BRecipe.IngredientResult result = BRecipe.loadIngredientVerbose(arg);
            if (result instanceof BRecipe.IngredientResult.Error) {
                BRecipe.IngredientResult.Error error = (BRecipe.IngredientResult.Error)result;
                return new Status.Error(error.error(), error.invalidPart());
            }
            this.ingredients.add(((BRecipe.IngredientResult.Success)result).ingredient());
            return this.update(arg);
        }

        private Status update(String arg) {
            this.prevArg = arg;
            return new Status.Updated();
        }

        public Status finish() {
            int cookedTime;
            if (this.options.contains((Object)Option.COOK)) {
                cookedTime = this.cookedTime;
            } else if (this.recipe != null) {
                cookedTime = this.recipe.getCookingTime();
            } else {
                return new Status.Error(ErrorType.MISSING_COOK, new Object[0]);
            }
            OptionalInt distill = this.options.contains((Object)Option.DISTILL) ? OptionalInt.of(this.distillRuns) : (this.recipe != null && this.recipe.needsDistilling() ? OptionalInt.of(this.recipe.getDistillruns()) : OptionalInt.empty());
            Age age = this.options.contains((Object)Option.AGE) ? new Age(this.woodType, this.ageTime) : (this.recipe != null ? Age.of(this.recipe) : null);
            ArrayList<RecipeItem> ingredients = new ArrayList<RecipeItem>();
            if (this.recipe != null && this.ingredients.isEmpty()) {
                ingredients.addAll(this.recipe.getIngredients());
            } else if (!this.ingredients.isEmpty()) {
                ingredients.addAll(this.ingredients);
            } else {
                return new Status.Error(ErrorType.MISSING_INGREDIENTS, new Object[0]);
            }
            return new Status.Finished(new SimulationParameters(cookedTime, distill, age, ingredients, this.brewer, this.player));
        }

        @Nullable
        public List<String> getTabCompletions() {
            return switch (this.state.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    ArrayList<String> completions = new ArrayList<String>();
                    if (this.prevArg == null) {
                        completions.addAll(helpStrings);
                    }
                    if (this.options.contains((Object)Option.RECIPE) || this.options.contains((Object)Option.COOK)) {
                        completions.addAll(SimulateCommand.getIngredientCompletions());
                    }
                    completions.addAll(this.getOptionCompletions());
                    yield completions;
                }
                case 1 -> SimulateCommand.getRecipeCompletions();
                case 2 -> BUtil.numberRange(1, 30);
                case 3 -> BUtil.numberRange(1, 10);
                case 4 -> BarrelWoodType.TAB_COMPLETIONS;
                case 5 -> BUtil.numberRange(1, 50);
                case 6, 7 -> null;
                case 8 -> SimulateCommand.getIngredientCompletions();
            };
        }

        private List<String> getOptionCompletions() {
            return EnumSet.complementOf(this.options).stream().map(Option::getOptions).flatMap(Collection::stream).toList();
        }

        public String toString() {
            return "SimulateCommand.SimulationParser(recipe=" + String.valueOf(this.recipe) + ", cookedTime=" + this.cookedTime + ", distillRuns=" + this.distillRuns + ", woodType=" + String.valueOf((Object)this.woodType) + ", ageTime=" + this.ageTime + ", ingredients=" + String.valueOf(this.ingredients) + ", brewer=" + String.valueOf(this.brewer) + ", player=" + String.valueOf(this.player) + ", options=" + String.valueOf(this.options) + ", state=" + String.valueOf((Object)this.state) + ", prevArg=" + this.prevArg + ")";
        }

        private static enum Option {
            RECIPE(State.RECIPE, "-r", "--recipe"),
            COOK(State.COOK, "-c", "--cook"),
            DISTILL(State.DISTILL, "-d", "--distill"),
            AGE(State.WOOD, "-a", "--age"),
            BREWER(State.BREWER, "-b", "--brewer"),
            PLAYER(State.PLAYER, "-p", "--player");

            private final State state;
            private final List<String> options;

            private Option(State state, String ... options) {
                this.state = state;
                this.options = List.of(options);
            }

            public boolean matches(String arg) {
                return this.options.contains(arg.toLowerCase(Locale.ROOT));
            }

            @Nullable
            public static Option get(String arg) {
                for (Option option : Option.values()) {
                    if (!option.matches(arg)) continue;
                    return option;
                }
                return null;
            }

            public State getState() {
                return this.state;
            }

            public List<String> getOptions() {
                return this.options;
            }
        }

        private static enum State {
            OPTIONS,
            RECIPE,
            COOK,
            DISTILL,
            WOOD,
            AGE,
            BREWER,
            PLAYER,
            INGREDIENTS;

        }
    }

    private static sealed interface Status {

        public record Error(Translatable error, Object[] args) implements Status
        {
        }

        public record Finished(SimulationParameters simulation) implements Status
        {
        }

        public record Help() implements Status
        {
        }

        public record Updated() implements Status
        {
        }
    }

    private record SimulationParameters(int cookedTime, OptionalInt distillRuns, @Nullable Age age, List<RecipeItem> ingredients, @Nullable Player brewer, @Nullable Player player) {
    }

    private record Age(BarrelWoodType barrelType, float ageTime) {
        @Nullable
        public static Age of(BRecipe recipe) {
            if (recipe.needsToAge()) {
                BarrelWoodType barrelType = recipe.getWood();
                return new Age(barrelType.isSpecific() ? barrelType : BarrelWoodType.OAK, recipe.getAge());
            }
            return null;
        }
    }

    private static enum ErrorType implements Translatable
    {
        INVALID_OPTION("CMD_Invalid_Option"),
        DUPLICATE_OPTION("CMD_Duplicate_Option"),
        RECIPE("Error_NoBrewName"),
        COOK("CMD_Invalid_Cook_Time"),
        DISTILL_RUNS("CMD_Invalid_Distill_Runs"),
        WOOD_TYPE("CMD_Invalid_Wood_Type"),
        AGE_TIME("CMD_Invalid_Age_Time"),
        PLAYER("Error_NoPlayer"),
        INVALID_INGREDIENT("CMD_Invalid_Ingredient"),
        MISSING_COOK("CMD_Missing_Cook_Time"),
        MISSING_INGREDIENTS("CMD_Missing_Ingredients");

        private final String translationKey;

        private ErrorType(String translationKey) {
            this.translationKey = translationKey;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

