/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.commands;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.commands.CommandUtil;
import com.dre.brewery.commands.SubCommand;
import com.dre.brewery.commands.subcommands.AgeCommand;
import com.dre.brewery.commands.subcommands.CopyCommand;
import com.dre.brewery.commands.subcommands.CreateCommand;
import com.dre.brewery.commands.subcommands.DataManagerCommand;
import com.dre.brewery.commands.subcommands.DebugInfoCommand;
import com.dre.brewery.commands.subcommands.DeleteCommand;
import com.dre.brewery.commands.subcommands.DistillCommand;
import com.dre.brewery.commands.subcommands.DrinkCommand;
import com.dre.brewery.commands.subcommands.HelpCommand;
import com.dre.brewery.commands.subcommands.InfoCommand;
import com.dre.brewery.commands.subcommands.ItemName;
import com.dre.brewery.commands.subcommands.PukeCommand;
import com.dre.brewery.commands.subcommands.ReloadAddonsCommand;
import com.dre.brewery.commands.subcommands.ReloadCommand;
import com.dre.brewery.commands.subcommands.SealCommand;
import com.dre.brewery.commands.subcommands.SetCommand;
import com.dre.brewery.commands.subcommands.ShowStatsCommand;
import com.dre.brewery.commands.subcommands.SimulateCommand;
import com.dre.brewery.commands.subcommands.StaticCommand;
import com.dre.brewery.commands.subcommands.UnLabelCommand;
import com.dre.brewery.commands.subcommands.VersionCommand;
import com.dre.brewery.commands.subcommands.WakeupCommand;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.utility.Logging;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManager
implements TabExecutor {
    private static final BreweryPlugin plugin = BreweryPlugin.getInstance();
    private static final Lang lang = ConfigManager.getConfig(Lang.class);
    private static final Map<String, SubCommand> subCommands = new HashMap<String, SubCommand>();

    public CommandManager() {
        CommandManager.addSubCommand("help", new HelpCommand());
        CommandManager.addSubCommand("reload", new ReloadCommand());
        CommandManager.addSubCommand("wakeup", new WakeupCommand());
        CommandManager.addSubCommand("itemName", new ItemName());
        CommandManager.addSubCommand("info", new InfoCommand());
        CommandManager.addSubCommand("seal", new SealCommand());
        CommandManager.addSubCommand("copy", new CopyCommand());
        CommandManager.addSubCommand("delete", new DeleteCommand());
        CommandManager.addSubCommand("static", new StaticCommand());
        CommandManager.addSubCommand("set", new SetCommand());
        CommandManager.addSubCommand("unLabel", new UnLabelCommand());
        CommandManager.addSubCommand("debuginfo", new DebugInfoCommand());
        CommandManager.addSubCommand("showstats", new ShowStatsCommand());
        CommandManager.addSubCommand("puke", new PukeCommand());
        CommandManager.addSubCommand("drink", new DrinkCommand());
        CommandManager.addSubCommand("reloadaddons", new ReloadAddonsCommand());
        CommandManager.addSubCommand("version", new VersionCommand());
        CommandManager.addSubCommand("data", new DataManagerCommand());
        CommandManager.addSubCommand("distill", new DistillCommand());
        CommandManager.addSubCommand("age", new AgeCommand());
        CommandManager.addSubCommand("simulate", new SimulateCommand());
        CommandManager.addSubCommand(new CreateCommand(), "create", "give");
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length < 1) {
            CommandUtil.cmdHelp(sender, args);
            return true;
        }
        SubCommand subCommand = subCommands.get(args[0]);
        if (subCommand == null) {
            CommandUtil.cmdHelp(sender, args);
            return true;
        }
        boolean playerOnly = subCommand.playerOnly();
        String permission = subCommand.permission();
        if (playerOnly && !(sender instanceof Player)) {
            lang.sendEntry(sender, "Error_NotPlayer", new Object[0]);
            return true;
        }
        if (permission != null && !sender.hasPermission(permission)) {
            lang.sendEntry(sender, "Error_NoPermissions", new Object[0]);
            return true;
        }
        subCommand.execute(plugin, lang, sender, s, args);
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        if (strings.length == 1) {
            ArrayList<String> commands = new ArrayList<String>();
            for (Map.Entry<String, SubCommand> entry : subCommands.entrySet()) {
                String perm = entry.getValue().permission();
                if (perm == null || !commandSender.hasPermission(perm)) continue;
                commands.add(entry.getKey());
            }
            return commands;
        }
        SubCommand subCommand = subCommands.get(strings[0].toLowerCase());
        if (subCommand != null) {
            return subCommand.tabComplete(plugin, commandSender, s, strings);
        }
        return null;
    }

    public static void addSubCommand(String name, SubCommand subCommand) {
        if (subCommands.containsKey(name)) {
            Logging.warningLog("SubCommand with name: &6" + name + " &ealready exists! It's being overwritten!");
        }
        subCommands.put(name, subCommand);
    }

    public static void addSubCommand(SubCommand subCommand, String ... names) {
        for (String name : names) {
            CommandManager.addSubCommand(name, subCommand);
        }
    }

    public static void removeSubCommand(String name) {
        subCommands.remove(name);
    }

    public static void removeSubCommand(String ... names) {
        for (String name : names) {
            subCommands.remove(name);
        }
    }

    public static void removeSubCommand(SubCommand subCommand) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, SubCommand> entry : subCommands.entrySet()) {
            if (entry.getValue() != subCommand) continue;
            keys.add(entry.getKey());
        }
        for (String key : keys) {
            subCommands.remove(key);
        }
    }

    public static void execute(Class<? extends SubCommand> clazz, CommandSender sender, String label, String[] args) {
        subCommands.values().stream().filter(subCommand -> subCommand.getClass().equals(clazz)).forEach(subCommand -> subCommand.execute(plugin, lang, sender, label, args));
    }
}

