/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.api.addons;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.addons.AddonCommand;
import com.dre.brewery.api.addons.AddonConfigManager;
import com.dre.brewery.api.addons.AddonFileManager;
import com.dre.brewery.api.addons.AddonInfo;
import com.dre.brewery.api.addons.AddonLogger;
import com.dre.brewery.api.addons.AddonManager;
import com.dre.brewery.commands.CommandManager;
import com.dre.brewery.depend.paperlib.PaperLib;
import com.dre.brewery.depend.universalScheduler.scheduling.schedulers.TaskScheduler;
import com.dre.brewery.storage.DataManager;
import com.dre.brewery.utility.MinecraftVersion;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class BreweryAddon {
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<String> commands = new ArrayList<String>();
    private URLClassLoader classLoader;
    private AddonInfo addonInfo;
    private AddonLogger logger;
    private AddonFileManager addonFileManager;
    private AddonConfigManager addonConfigManager;
    private File addonFile;

    public void onAddonPreEnable() {
    }

    public void onAddonEnable() {
    }

    public void onAddonDisable() {
    }

    public void onBreweryReload() {
    }

    @NotNull
    public AddonInfo getAddonInfo() {
        return this.addonInfo;
    }

    @NotNull
    public AddonFileManager getAddonFileManager() {
        return this.addonFileManager;
    }

    @NotNull
    public AddonConfigManager getAddonConfigManager() {
        return this.addonConfigManager;
    }

    @NotNull
    public AddonLogger getAddonLogger() {
        return this.logger;
    }

    @NotNull
    public File getAddonFile() {
        return this.addonFile;
    }

    public void registerListener(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)BreweryPlugin.getInstance());
        this.listeners.add(listener);
    }

    public void unregisterListener(Listener listener) {
        HandlerList.unregisterAll((Listener)listener);
        this.listeners.remove(listener);
    }

    public void registerCommand(String name, AddonCommand command) {
        CommandManager.addSubCommand(name, command);
        this.commands.add(name);
    }

    public void unregisterCommand(String name) {
        CommandManager.removeSubCommand(name);
        this.commands.remove(name);
    }

    public void unregisterListeners() {
        for (Listener listener : this.listeners) {
            HandlerList.unregisterAll((Listener)listener);
        }
        this.listeners.clear();
    }

    public void unregisterCommands() {
        for (String command : this.commands) {
            CommandManager.removeSubCommand(command);
        }
        this.commands.clear();
    }

    @NotNull
    public BreweryPlugin getBreweryPlugin() {
        return BreweryPlugin.getInstance();
    }

    @NotNull
    public TaskScheduler getScheduler() {
        return BreweryPlugin.getScheduler();
    }

    @NotNull
    public DataManager getDataManager() {
        return BreweryPlugin.getDataManager();
    }

    @NotNull
    public AddonManager getAddonManager() {
        return BreweryPlugin.getAddonManager();
    }

    @NotNull
    public MinecraftVersion getMCVersion() {
        return BreweryPlugin.getMCVersion();
    }

    public boolean isFolia() {
        return MinecraftVersion.isFolia();
    }

    public boolean isPaper() {
        return PaperLib.isPaper();
    }

    public Set<Class<?>> findClasses(String packageName) throws IOException {
        URLClassLoader classLoader = new URLClassLoader(new URL[]{this.getAddonFile().toURI().toURL()}, this.getClass().getClassLoader());
        return ClassPath.from((ClassLoader)classLoader).getAllClasses().stream().filter(clazz -> clazz.getPackageName().equalsIgnoreCase(packageName)).map(ClassPath.ClassInfo::load).collect(Collectors.toSet());
    }
}

