/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BarrelWoodType;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.recipe.DebuggableItem;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.utility.BUtil;
import java.util.List;
import java.util.Locale;

public interface BrewDefect {
    public List<String> getMessages(Lang var1);

    public record NoRecipesRegistered() implements BrewDefect
    {
        @Override
        public List<String> getMessages(Lang lang) {
            return lang.getEntries("Defect_NoRecipesRegistered", new Object[0]);
        }

        @Override
        public String toString() {
            return "NoRecipesRegistered{}";
        }
    }

    public record WrongWood(BarrelWoodType actual, BarrelWoodType needed) implements BrewDefect
    {
        public WrongWood {
            if (actual == needed) {
                throw new IllegalArgumentException("WrongWood actual and needed were equal");
            }
        }

        @Override
        public List<String> getMessages(Lang lang) {
            return lang.getEntries("Defect_WrongWood", this.actual.getFormattedName().toLowerCase(Locale.ROOT));
        }

        @Override
        public String toString() {
            return String.format("WrongWood{was %s, needs %s}", this.actual.getFormattedName(), this.needed.getFormattedName());
        }
    }

    public record AgeMismatch(float actual, float needed, boolean alcoholic) implements BrewDefect
    {
        public AgeMismatch {
            if (BUtil.isClose(actual, needed)) {
                throw new IllegalArgumentException("AgeMismatch actual and needed were equal");
            }
        }

        @Override
        public List<String> getMessages(Lang lang) {
            if (this.needed == 0.0f) {
                return lang.getEntries("Defect_BadAged", new Object[0]);
            }
            if (this.actual < this.needed) {
                return lang.getEntries("Defect_UnderAged", new Object[0]);
            }
            if (this.alcoholic) {
                return lang.getEntries("Defect_OverAgedAlc", new Object[0]);
            }
            return lang.getEntries("Defect_OverAged", new Object[0]);
        }

        @Override
        public String toString() {
            return String.format("AgeMismatch{%.3f/%.3f}", Float.valueOf(this.actual), Float.valueOf(this.needed));
        }
    }

    public record CookTimeMismatch(int actual, int needed) implements BrewDefect
    {
        public CookTimeMismatch {
            if (actual == needed) {
                throw new IllegalArgumentException("CookTimeMismatch actual and needed were equal");
            }
        }

        @Override
        public List<String> getMessages(Lang lang) {
            if (this.actual < this.needed) {
                return lang.getEntries("Defect_Uncooked", new Object[0]);
            }
            return lang.getEntries("Defect_Overcooked", new Object[0]);
        }

        @Override
        public String toString() {
            return String.format("CookTimeMismatch{%d/%d}", this.actual, this.needed);
        }
    }

    public record CookingNotNeeded() implements BrewDefect
    {
        @Override
        public List<String> getMessages(Lang lang) {
            return lang.getEntries("Defect_Overcooked", new Object[0]);
        }

        @Override
        public String toString() {
            return "CookingNotNeeded{}";
        }
    }

    public record DistillMismatch(boolean actual, boolean needed, boolean alcoholic) implements BrewDefect
    {
        public DistillMismatch {
            if (actual == needed) {
                throw new IllegalArgumentException("DistillMismatch actual and needed were equal");
            }
        }

        @Override
        public List<String> getMessages(Lang lang) {
            if (this.needed) {
                if (this.alcoholic) {
                    return lang.getEntries("Defect_NeedsDistillAlc", new Object[0]);
                }
                return lang.getEntries("Defect_NeedsDistill", new Object[0]);
            }
            return lang.getEntries("Defect_BadDistill", new Object[0]);
        }

        @Override
        public String toString() {
            return this.needed ? "DistillNeeded" : "DistillUnnecessary";
        }
    }

    public record WrongCount(Ingredient ingredient, int amountNeeded) implements BrewDefect
    {
        public WrongCount {
            if (ingredient.getAmount() == amountNeeded) {
                throw new IllegalArgumentException("WrongCount actual and needed counts were equal");
            }
        }

        @Override
        public List<String> getMessages(Lang lang) {
            if (this.ingredient.getAmount() < this.amountNeeded) {
                return lang.getEntries("Defect_LowCount", new Object[0]);
            }
            return lang.getEntries("Defect_HighCount", new Object[0]);
        }

        @Override
        public String toString() {
            return String.format("WrongCount{%d/%d %s}", this.ingredient.getAmount(), this.amountNeeded, this.ingredient.getDebugID());
        }
    }

    public record MissingIngredient(DebuggableItem ingredient, int amountNeeded) implements BrewDefect
    {
        @Override
        public List<String> getMessages(Lang lang) {
            return lang.getEntries("Defect_MissingIngredient", new Object[0]);
        }

        @Override
        public String toString() {
            return String.format("MissingIngredient{%dx %s}", this.amountNeeded, this.ingredient.getDebugID());
        }
    }

    public record WrongIngredient(DebuggableItem ingredient) implements BrewDefect
    {
        @Override
        public List<String> getMessages(Lang lang) {
            return lang.getEntries("Defect_WrongIngredient", new Object[0]);
        }

        @Override
        public String toString() {
            return String.format("WrongIngredient{%s}", this.ingredient.getDebugID());
        }
    }
}

