/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BarrelAsset;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.MaterialUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalInt;
import org.bukkit.Material;
import org.jetbrains.annotations.Nullable;

public enum BarrelWoodType {
    ANY("Any", 0, true),
    BIRCH("Birch", 1),
    OAK("Oak", 2),
    JUNGLE("Jungle", 3),
    SPRUCE("Spruce", 4),
    ACACIA("Acacia", 5),
    DARK_OAK("Dark Oak", 6),
    CRIMSON("Crimson", 7),
    WARPED("Warped", 8),
    MANGROVE("Mangrove", 9),
    CHERRY("Cherry", 10),
    BAMBOO("Bamboo", 11),
    CUT_COPPER("Cut Copper", 12, Material.CUT_COPPER, Material.CUT_COPPER_STAIRS, Material.WAXED_CUT_COPPER, Material.WAXED_CUT_COPPER_STAIRS, Material.EXPOSED_CUT_COPPER, Material.EXPOSED_CUT_COPPER_STAIRS, Material.WAXED_EXPOSED_CUT_COPPER, Material.WAXED_EXPOSED_CUT_COPPER_STAIRS, Material.WEATHERED_CUT_COPPER, Material.WEATHERED_CUT_COPPER_STAIRS, Material.WAXED_WEATHERED_CUT_COPPER, Material.WAXED_WEATHERED_CUT_COPPER_STAIRS, Material.OXIDIZED_CUT_COPPER, Material.OXIDIZED_CUT_COPPER_STAIRS, Material.WAXED_OXIDIZED_CUT_COPPER, Material.WAXED_OXIDIZED_CUT_COPPER_STAIRS),
    PALE_OAK("Pale Oak", 13),
    NONE("None", -1, true);

    public static final int MAX_DISTANCE = 5;
    public static final int COPPER_DISTANCE = 4;
    public static final List<String> TAB_COMPLETIONS;
    private final String formattedName;
    private final int index;

    private BarrelWoodType(String formattedName, int index) {
        this(formattedName, index, false);
    }

    private BarrelWoodType(String formattedName, int index, boolean exclude) {
        this.formattedName = formattedName;
        this.index = index;
        if (!exclude) {
            BarrelAsset.addBarrelAsset(this, BarrelAsset.PLANKS, this.getStandardBarrelAssetMaterial(BarrelAsset.PLANKS));
            BarrelAsset.addBarrelAsset(this, BarrelAsset.STAIRS, this.getStandardBarrelAssetMaterial(BarrelAsset.STAIRS));
            BarrelAsset.addBarrelAsset(this, BarrelAsset.SIGN, this.getStandardBarrelAssetMaterial(BarrelAsset.SIGN));
            BarrelAsset.addBarrelAsset(this, BarrelAsset.FENCE, this.getStandardBarrelAssetMaterial(BarrelAsset.FENCE));
        }
    }

    private BarrelWoodType(String formattedName, int index, Material planks, Material stairs, Material sign, Material fence) {
        this.formattedName = formattedName;
        this.index = index;
        BarrelAsset.addBarrelAsset(this, BarrelAsset.PLANKS, planks);
        BarrelAsset.addBarrelAsset(this, BarrelAsset.STAIRS, stairs);
        BarrelAsset.addBarrelAsset(this, BarrelAsset.SIGN, sign);
        BarrelAsset.addBarrelAsset(this, BarrelAsset.FENCE, fence);
    }

    private BarrelWoodType(String formattedName, int index, Material planks, Material stairs) {
        this.formattedName = formattedName;
        this.index = index;
        BarrelAsset.addBarrelAsset(this, BarrelAsset.PLANKS, planks);
        BarrelAsset.addBarrelAsset(this, BarrelAsset.STAIRS, stairs);
    }

    private BarrelWoodType(String formattedName, int index, Material ... materials) {
        this.formattedName = formattedName;
        this.index = index;
        if (materials == null) {
            return;
        }
        for (Material material : materials) {
            boolean isStairs = material.name().contains("STAIRS");
            BarrelAsset.addBarrelAsset(this, isStairs ? BarrelAsset.STAIRS : BarrelAsset.PLANKS, material);
        }
    }

    @Nullable
    private Material[] getStandardBarrelAssetMaterial(BarrelAsset assetType) {
        try {
            if (assetType == BarrelAsset.SIGN) {
                return new Material[]{Material.valueOf((String)(this.name() + "_" + assetType.name())), Material.valueOf((String)(this.name() + "_WALL_SIGN"))};
            }
            return new Material[]{Material.valueOf((String)(this.name() + "_" + assetType.name()))};
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean isSpecific() {
        return this != ANY && this != NONE;
    }

    public int getDistance(BarrelWoodType other) {
        Group group = Group.of(this);
        Group otherGroup = Group.of(other);
        if (group == null || otherGroup == null) {
            return -1;
        }
        if (this == other) {
            return 0;
        }
        return group.getDistance(otherGroup) + 1;
    }

    public BarrelWoodType stepTowards(BarrelWoodType other, int steps) {
        if (this == other || steps >= 5) {
            return other;
        }
        Group group = Group.of(this);
        Group otherGroup = Group.of(other);
        if (group == null || otherGroup == null) {
            return this;
        }
        if (group == otherGroup) {
            return other;
        }
        return group.stepTowards((Group)otherGroup, (int)steps).members[0];
    }

    public static BarrelWoodType fromName(String name) {
        for (BarrelWoodType type : BarrelWoodType.values()) {
            if (!type.name().equalsIgnoreCase(name) && !type.formattedName.equalsIgnoreCase(name)) continue;
            return type;
        }
        return ANY;
    }

    public static BarrelWoodType fromIndex(int index) {
        for (BarrelWoodType type : BarrelWoodType.values()) {
            if (type.index != index) continue;
            return type;
        }
        return ANY;
    }

    public static BarrelWoodType fromMaterial(Material material) {
        for (BarrelWoodType type : BarrelWoodType.values()) {
            if (material.name().toUpperCase().startsWith(type.name().toUpperCase())) {
                return type;
            }
            if (type != CUT_COPPER || material.name().toUpperCase().contains("SLAB") || !material.name().toUpperCase().contains(type.name().toUpperCase())) continue;
            return type;
        }
        return ANY;
    }

    public static BarrelWoodType fromAny(Object intOrString) {
        if (intOrString instanceof Integer) {
            Integer integer = (Integer)intOrString;
            return BarrelWoodType.fromIndex(integer);
        }
        if (intOrString instanceof String) {
            String s = (String)intOrString;
            return BarrelWoodType.fromName(s);
        }
        if (intOrString instanceof Float || intOrString instanceof Double) {
            return BarrelWoodType.fromIndex((int)((Float)intOrString).floatValue());
        }
        if (intOrString instanceof Material) {
            Material m = (Material)intOrString;
            return BarrelWoodType.fromMaterial(m);
        }
        return ANY;
    }

    public static List<BarrelWoodType> listFromAny(Object intOrStringOrList) {
        if (intOrStringOrList instanceof List) {
            List list = (List)intOrStringOrList;
            return list.stream().map(BarrelWoodType::fromAny).toList();
        }
        return Collections.singletonList(BarrelWoodType.fromAny(intOrStringOrList));
    }

    public static BarrelWoodType parse(String string) {
        Material material;
        OptionalInt indexOpt = BUtil.parseInt(string);
        if (indexOpt.isPresent()) {
            int index = indexOpt.getAsInt();
            for (BarrelWoodType type : BarrelWoodType.values()) {
                if (type.index != index) continue;
                return type;
            }
        }
        if ((material = MaterialUtil.getMaterialSafely(string)) != null) {
            return BarrelWoodType.fromMaterial(material);
        }
        return BarrelWoodType.fromName(string);
    }

    public String getFormattedName() {
        return this.formattedName;
    }

    public int getIndex() {
        return this.index;
    }

    static {
        TAB_COMPLETIONS = Arrays.stream(BarrelWoodType.values()).filter(BarrelWoodType::isSpecific).map(BarrelWoodType::getFormattedName).map(s -> s.replace(' ', '_')).toList();
    }

    private static final class Group
    extends Enum<Group> {
        public static final /* enum */ Group COLD = new Group(new Properties.Normal(Temperature.COLD, Humidity.MODERATE), SPRUCE);
        public static final /* enum */ Group TEMPERATE = new Group(new Properties.Normal(Temperature.WARM, Humidity.MODERATE), BIRCH, CHERRY);
        public static final /* enum */ Group OAK = new Group(new Properties.Normal(Temperature.WARM, Humidity.MODERATE, true), OAK, DARK_OAK, PALE_OAK);
        public static final /* enum */ Group HOT_HUMID = new Group(new Properties.Normal(Temperature.HOT, Humidity.HUMID), JUNGLE, MANGROVE, BAMBOO);
        public static final /* enum */ Group HOT_DRY = new Group(new Properties.Normal(Temperature.HOT, Humidity.DRY), ACACIA);
        public static final /* enum */ Group NETHER = new Group(new Properties.Normal(Temperature.NETHER, Humidity.DRY), CRIMSON, WARPED);
        public static final /* enum */ Group SPECIAL = new Group(new Properties.Special(), CUT_COPPER);
        public static final int MAX_DISTANCE = 4;
        public static final int SPECIAL_DISTANCE = 3;
        private final Properties properties;
        private final BarrelWoodType[] members;
        private static final /* synthetic */ Group[] $VALUES;

        public static Group[] values() {
            return (Group[])$VALUES.clone();
        }

        public static Group valueOf(String name) {
            return Enum.valueOf(Group.class, name);
        }

        private Group(Properties properties, BarrelWoodType ... members) {
            this.properties = properties;
            this.members = members;
        }

        public static Group of(BarrelWoodType type) {
            for (Group group : Group.values()) {
                if (!group.contains(type)) continue;
                return group;
            }
            return null;
        }

        private boolean contains(BarrelWoodType type) {
            for (BarrelWoodType member : this.members) {
                if (member != type) continue;
                return true;
            }
            return false;
        }

        public int getDistance(Group other) {
            Properties.Normal props;
            Properties properties;
            block6: {
                block5: {
                    assert (other != null);
                    if (this == other) {
                        return 0;
                    }
                    properties = this.properties;
                    if (!(properties instanceof Properties.Normal)) break block5;
                    props = (Properties.Normal)properties;
                    properties = other.properties;
                    if (properties instanceof Properties.Normal) break block6;
                }
                return 3;
            }
            Properties.Normal otherProps = (Properties.Normal)properties;
            int temperatureDistance = Math.abs(props.temperature.ordinal() - otherProps.temperature.ordinal());
            int humidityDistance = Math.abs(props.humidity.ordinal() - otherProps.humidity.ordinal());
            int oakDistance = props.oak != otherProps.oak ? 1 : 0;
            return temperatureDistance + humidityDistance + oakDistance;
        }

        public Group stepTowards(Group to, int steps) {
            assert (to != null);
            Comparator<Group> comparatorInitial = Comparator.comparing(g -> g.getDistance(to));
            Comparator<Group> comparator = comparatorInitial.thenComparing(Enum::ordinal);
            return Arrays.stream(Group.values()).filter(g -> this.getDistance((Group)((Object)g)) <= steps).min(comparator).filter(g -> g.getDistance(to) < this.getDistance(to)).orElse(this);
        }

        private static /* synthetic */ Group[] $values() {
            return new Group[]{COLD, TEMPERATE, OAK, HOT_HUMID, HOT_DRY, NETHER, SPECIAL};
        }

        static {
            $VALUES = Group.$values();
        }
    }

    private static enum Humidity {
        DRY,
        MODERATE,
        HUMID;

    }

    private static enum Temperature {
        COLD,
        WARM,
        HOT,
        NETHER;

    }

    private static sealed interface Properties {

        public record Special() implements Properties
        {
        }

        public record Normal(Temperature temperature, Humidity humidity, boolean oak) implements Properties
        {
            public Normal(Temperature temperature, Humidity humidity) {
                this(temperature, humidity, false);
            }
        }
    }
}

