/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BarrelWoodType;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Material;

public enum BarrelAsset {
    PLANKS,
    STAIRS,
    SIGN,
    FENCE;

    private static final Map<BarrelWoodType, Map<BarrelAsset, Set<Material>>> barrelAssetListMap;

    public static void addBarrelAsset(BarrelWoodType type, BarrelAsset asset, Material ... materials) {
        if (materials == null) {
            return;
        }
        Collections.addAll(barrelAssetListMap.computeIfAbsent(type, ignored -> new HashMap()).computeIfAbsent(asset, ignored -> new HashSet()), (Material[])Arrays.stream(materials).filter(Objects::nonNull).toArray(Material[]::new));
    }

    public static boolean isBarrelAsset(BarrelAsset assetType, Material material) {
        if (material == null) {
            return false;
        }
        return barrelAssetListMap.values().stream().map(b -> b.getOrDefault((Object)assetType, Set.of())).anyMatch(materialSet -> materialSet.contains(material));
    }

    public static Set<Material> getMaterialsOf(BarrelWoodType type) {
        EnumSet<Material> output = EnumSet.noneOf(Material.class);
        barrelAssetListMap.get((Object)type).values().forEach(output::addAll);
        return output;
    }

    static {
        barrelAssetListMap = new HashMap<BarrelWoodType, Map<BarrelAsset, Set<Material>>>();
    }
}

