/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BarrelAsset;
import com.dre.brewery.BarrelBody;
import com.dre.brewery.BarrelWoodType;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.events.barrel.BarrelAccessEvent;
import com.dre.brewery.api.events.barrel.BarrelCreateEvent;
import com.dre.brewery.api.events.barrel.BarrelDestroyEvent;
import com.dre.brewery.api.events.barrel.BarrelRemoveEvent;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.depend.universalScheduler.UniversalRunnable;
import com.dre.brewery.integration.Hook;
import com.dre.brewery.integration.barrel.LogBlockBarrel;
import com.dre.brewery.lore.BrewLore;
import com.dre.brewery.utility.BoundingBox;
import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.MinecraftVersion;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Barrel
extends BarrelBody
implements InventoryHolder {
    private static final Map<UUID, List<Barrel>> barrels = new ConcurrentHashMap<UUID, List<Barrel>>();
    private static final Config config = ConfigManager.getConfig(Config.class);
    private static final Lang lang = ConfigManager.getConfig(Lang.class);
    private static Map<UUID, Integer> checkCounters = new ConcurrentHashMap<UUID, Integer>();
    private final boolean small;
    private boolean checked;
    private Inventory inventory;
    private float time;
    private final UUID id;

    public Barrel(Block spigot, byte signoffset) {
        super(spigot, signoffset);
        this.small = this.computeSmall();
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(!this.small ? config.getBarrelInvSizeLarge() * 9 : config.getBarrelInvSizeSmall() * 9), (String)lang.getEntry("Etc_Barrel", new Object[0]));
        this.id = UUID.randomUUID();
    }

    public Barrel(Block spigot, byte signoffset, boolean isSmall) {
        super(spigot, signoffset);
        this.small = isSmall;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(!isSmall ? config.getBarrelInvSizeLarge() * 9 : config.getBarrelInvSizeSmall() * 9), (String)lang.getEntry("Etc_Barrel", new Object[0]));
        this.id = UUID.randomUUID();
    }

    public Barrel(Block spigot, byte sign, BoundingBox bounds, @Nullable Map<String, Object> items, float time, UUID id, boolean isSmall) {
        super(spigot, sign, bounds);
        this.small = isSmall;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(this.isLarge() ? config.getBarrelInvSizeLarge() * 9 : config.getBarrelInvSizeSmall() * 9), (String)lang.getEntry("Etc_Barrel", new Object[0]));
        if (items != null) {
            for (String slot : items.keySet()) {
                if (!(items.get(slot) instanceof ItemStack)) continue;
                this.inventory.setItem(Integer.parseInt(slot), (ItemStack)items.get(slot));
            }
        }
        this.time = time;
        this.id = id;
    }

    public Barrel(Block spigot, byte sign, BoundingBox bounds, ItemStack[] items, float time, UUID id, boolean isSmall) {
        super(spigot, sign, bounds);
        this.small = isSmall;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(this.isLarge() ? config.getBarrelInvSizeLarge() * 9 : config.getBarrelInvSizeSmall() * 9), (String)lang.getEntry("Etc_Barrel", new Object[0]));
        if (items != null) {
            for (int slot = 0; slot < items.length; ++slot) {
                if (items[slot] == null) continue;
                this.inventory.setItem(slot, items[slot]);
            }
        }
        this.time = time;
        this.id = id;
    }

    public static void onUpdate() {
        barrels.values().stream().flatMap(Collection::stream).filter(Objects::nonNull).forEach(barrel -> barrel.time += (float)(1.0 / (double)config.getAgingYearDuration()));
        for (UUID worldUuid : barrels.keySet()) {
            Barrel randomInTheBack;
            List<Barrel> worldBarrels = barrels.get(worldUuid);
            int numBarrels = worldBarrels.size();
            if (checkCounters.getOrDefault(worldUuid, 0) != 0 || numBarrels <= 0) continue;
            Barrel random = worldBarrels.get((int)Math.floor(Math.random() * (double)numBarrels));
            if (random != null) {
                random.checked = false;
            }
            if (numBarrels > 50 && (randomInTheBack = worldBarrels.get(numBarrels - 1 - (int)(Math.random() * (double)(numBarrels >>> 2)))) != null) {
                randomInTheBack.checked = false;
            }
            new BarrelCheck().runTaskTimer((Plugin)BreweryPlugin.getInstance(), 1L, 1L);
        }
    }

    @NotNull
    public static List<Barrel> getBarrels(UUID worldUuid) {
        List<Barrel> worldBarrels = barrels.get(worldUuid);
        return worldBarrels == null ? List.of() : worldBarrels;
    }

    public boolean hasPermsOpen(Player player, PlayerInteractEvent event) {
        if (this.isLarge()) {
            if (!player.hasPermission("brewery.openbarrel.big")) {
                lang.sendEntry((CommandSender)player, "Error_NoBarrelAccess", new Object[0]);
                return false;
            }
        } else if (!player.hasPermission("brewery.openbarrel.small")) {
            lang.sendEntry((CommandSender)player, "Error_NoBarrelAccess", new Object[0]);
            return false;
        }
        BarrelAccessEvent accessEvent = new BarrelAccessEvent(this, player, event.getClickedBlock(), event.getBlockFace());
        BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)accessEvent);
        return !accessEvent.isCancelled();
    }

    public boolean hasPermsDestroy(Player player, Block block, BarrelDestroyEvent.Reason reason) {
        BarrelDestroyEvent destroyEvent = new BarrelDestroyEvent(this, block, reason, player);
        BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)destroyEvent);
        return !destroyEvent.isCancelled();
    }

    public void open(Player player) {
        if (this.inventory == null) {
            this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(this.isLarge() ? config.getBarrelInvSizeLarge() * 9 : config.getBarrelInvSizeSmall() * 9), (String)lang.getEntry("Etc_Barrel", new Object[0]));
        } else if (this.time > 0.0f && this.inventory.getViewers().isEmpty() && this.inventory.contains(Material.POTION)) {
            BarrelWoodType wood = this.getWood();
            long loadTime = System.nanoTime();
            for (ItemStack item : this.inventory.getContents()) {
                Brew brew;
                if (item == null || (brew = Brew.get(item)) == null) continue;
                brew.age(item, this.time, wood);
            }
            loadTime = System.nanoTime() - loadTime;
            float ftime = (float)((double)loadTime / 1000000.0);
            Logging.debugLog("opening Barrel with potions (" + ftime + "ms)");
        }
        this.time = 0.0f;
        if (Hook.LOGBLOCK.isEnabled()) {
            try {
                LogBlockBarrel.openBarrel((HumanEntity)player, this.inventory, this.spigot.getLocation());
            }
            catch (Throwable e) {
                Logging.errorLog("Failed to Log Barrel to LogBlock!", e);
            }
        }
        player.openInventory(this.inventory);
    }

    public void playOpeningSound() {
        float randPitch = (float)(Math.random() * 0.1);
        Location location = this.getSpigot().getLocation();
        if (location.getWorld() == null) {
            return;
        }
        if (this.isLarge()) {
            location.getWorld().playSound(location, Sound.BLOCK_CHEST_OPEN, SoundCategory.BLOCKS, 0.4f, 0.55f + randPitch);
            location.getWorld().playSound(location, Sound.BLOCK_BREWING_STAND_BREW, SoundCategory.BLOCKS, 0.4f, 0.45f + randPitch);
        } else {
            location.getWorld().playSound(location, Sound.BLOCK_BARREL_OPEN, SoundCategory.BLOCKS, 0.5f, 0.8f + randPitch);
        }
    }

    public void playClosingSound() {
        float randPitch = (float)(Math.random() * 0.1);
        Location location = this.getSpigot().getLocation();
        if (location.getWorld() == null) {
            return;
        }
        if (this.isLarge()) {
            location.getWorld().playSound(location, Sound.BLOCK_BARREL_CLOSE, SoundCategory.BLOCKS, 0.5f, 0.5f + randPitch);
            location.getWorld().playSound(location, Sound.ITEM_BUCKET_EMPTY, SoundCategory.BLOCKS, 0.2f, 0.6f + randPitch);
        } else {
            location.getWorld().playSound(location, Sound.BLOCK_BARREL_CLOSE, SoundCategory.BLOCKS, 0.5f, 0.8f + randPitch);
        }
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @Deprecated
    public boolean hasWoodBlock(Block block) {
        return this.hasBlock(block);
    }

    @Deprecated
    public boolean hasStairsBlock(Block block) {
        return this.hasBlock(block);
    }

    @Nullable
    public static Barrel get(Block block) {
        if (block == null) {
            return null;
        }
        Material type = block.getType();
        if (BarrelAsset.isBarrelAsset(BarrelAsset.FENCE, type) || BarrelAsset.isBarrelAsset(BarrelAsset.SIGN, type)) {
            return Barrel.getBySpigot(block);
        }
        return Barrel.getByWood(block);
    }

    @Nullable
    public static Barrel getBySpigot(Block sign) {
        List<Barrel> worldBarrels;
        Block spigot = BarrelBody.getSpigotOfSign(sign);
        byte signoffset = 0;
        if (!spigot.equals((Object)sign)) {
            signoffset = (byte)(sign.getY() - spigot.getY());
        }
        if ((worldBarrels = barrels.get(sign.getWorld().getUID())) == null) {
            return null;
        }
        int i = 0;
        for (Barrel barrel : worldBarrels) {
            if (barrel != null && barrel.isSignOfBarrel(signoffset) && barrel.spigot.equals((Object)spigot)) {
                if (barrel.getSignoffset() == 0 && signoffset != 0) {
                    barrel.setSignoffset(signoffset);
                }
                Barrel.moveMRU(sign.getWorld().getUID(), i);
                return barrel;
            }
            ++i;
        }
        return null;
    }

    @Nullable
    public static Barrel getByWood(Block wood) {
        if (!BarrelAsset.isBarrelAsset(BarrelAsset.PLANKS, wood.getType()) && !BarrelAsset.isBarrelAsset(BarrelAsset.STAIRS, wood.getType())) {
            return null;
        }
        List<Barrel> worldBarrels = barrels.get(wood.getWorld().getUID());
        if (worldBarrels == null) {
            return null;
        }
        for (int i = 0; i < worldBarrels.size(); ++i) {
            Barrel barrel = worldBarrels.get(i);
            if (!barrel.getSpigot().getWorld().equals((Object)wood.getWorld()) || !barrel.getBounds().contains(wood)) continue;
            Barrel.moveMRU(wood.getWorld().getUID(), i);
            return barrel;
        }
        return null;
    }

    private static void moveMRU(UUID worldUuid, int index) {
        if (index <= 0) {
            return;
        }
        List<Barrel> worldBarrels = barrels.get(worldUuid);
        if (index >= worldBarrels.size()) {
            return;
        }
        worldBarrels.set(index - 1, worldBarrels.set(index, worldBarrels.get(index - 1)));
    }

    public static boolean create(Block sign, Player player) {
        Barrel barrel;
        Block spigot = BarrelBody.getSpigotOfSign(sign);
        if (Barrel.get(spigot) != null) {
            return false;
        }
        byte signoffset = 0;
        if (!spigot.equals((Object)sign)) {
            signoffset = (byte)(sign.getY() - spigot.getY());
        }
        if ((barrel = Barrel.getBySpigot(spigot)) == null) {
            barrel = new Barrel(spigot, signoffset);
            if (barrel.getBrokenBlock(true) == null) {
                if (Barrel.overlapsExistingBarrel(barrel)) {
                    return false;
                }
                if (BarrelAsset.isBarrelAsset(BarrelAsset.SIGN, spigot.getType())) {
                    if (!player.hasPermission("brewery.createbarrel.small")) {
                        lang.sendEntry((CommandSender)player, "Perms_NoBarrelCreate", new Object[0]);
                        return false;
                    }
                } else if (!player.hasPermission("brewery.createbarrel.big")) {
                    lang.sendEntry((CommandSender)player, "Perms_NoBigBarrelCreate", new Object[0]);
                    return false;
                }
                BarrelCreateEvent createEvent = new BarrelCreateEvent(barrel, player);
                BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)createEvent);
                if (!createEvent.isCancelled()) {
                    barrels.computeIfAbsent(sign.getWorld().getUID(), ignored -> new ArrayList()).addFirst(barrel);
                    return true;
                }
            }
        } else if (barrel.getSignoffset() == 0 && signoffset != 0) {
            barrel.setSignoffset(signoffset);
            return true;
        }
        return false;
    }

    private static boolean overlapsExistingBarrel(Barrel candidate) {
        BoundingBox candidateBounds = candidate.getBounds();
        if (candidateBounds == null) {
            return false;
        }
        List<Barrel> worldBarrels = barrels.get(candidate.getSpigot().getWorld().getUID());
        if (worldBarrels == null) {
            return false;
        }
        for (Barrel existing : worldBarrels) {
            if (existing == null) continue;
            if (existing.getSpigot().equals((Object)candidate.getSpigot())) {
                return true;
            }
            BoundingBox existingBounds = existing.getBounds();
            if (existingBounds == null || !existingBounds.intersects(candidateBounds)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void remove(@Nullable Block broken, @Nullable Player breaker, boolean dropItems) {
        BarrelRemoveEvent event = new BarrelRemoveEvent(this, dropItems);
        BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)event);
        if (this.inventory != null) {
            ArrayList viewers = new ArrayList(this.inventory.getViewers());
            for (HumanEntity viewer : viewers) {
                viewer.closeInventory();
            }
            ItemStack[] items = this.inventory.getContents();
            this.inventory.clear();
            if (Hook.LOGBLOCK.isEnabled() && breaker != null) {
                try {
                    LogBlockBarrel.breakBarrel(breaker, items, this.spigot.getLocation());
                }
                catch (Throwable e) {
                    Logging.errorLog("Failed to Log Barrel-break to LogBlock!", e);
                }
            }
            if (event.willDropItems()) {
                if (this.getBounds() == null) {
                    Logging.debugLog("Barrel Body is null, can't drop items: " + String.valueOf(this.id));
                    ((List)barrels.getOrDefault(this.spigot.getWorld().getUID(), new ArrayList())).remove(this);
                    return;
                }
                BarrelWoodType wood = this.getWood();
                for (ItemStack item : items) {
                    try {
                        if (item == null) continue;
                        Brew brew = Brew.get(item);
                        if (brew != null) {
                            brew.age(item, this.time, wood);
                            PotionMeta meta = (PotionMeta)item.getItemMeta();
                            if (BrewLore.hasColorLore(meta)) {
                                BrewLore lore = new BrewLore(brew, meta);
                                lore.convertLore(false);
                                lore.write();
                                item.setItemMeta((ItemMeta)meta);
                            }
                        }
                        if (broken != null) {
                            broken.getWorld().dropItem(broken.getLocation(), item);
                            continue;
                        }
                        this.spigot.getWorld().dropItem(this.spigot.getLocation(), item);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        ((List)barrels.getOrDefault(this.spigot.getWorld().getUID(), new ArrayList())).remove(this);
    }

    @Override
    public boolean regenerateBounds() {
        Logging.debugLog("Regenerating Barrel BoundingBox: " + (String)(this.bounds == null ? "was null" : "volume=" + this.bounds.volume()));
        Block broken = this.getBrokenBlock(true);
        if (broken != null) {
            this.remove(broken, null, true);
            return false;
        }
        return true;
    }

    public boolean isLarge() {
        return !this.isSmall();
    }

    private boolean computeSmall() {
        Preconditions.checkState((boolean)BreweryPlugin.getScheduler().isRegionThread(this.spigot.getLocation()));
        return BarrelAsset.isBarrelAsset(BarrelAsset.SIGN, this.spigot.getType());
    }

    public static CompletableFuture<Boolean> computeSmall(Location spigotPosition) {
        if (!MinecraftVersion.isFolia()) {
            return CompletableFuture.completedFuture(BarrelAsset.isBarrelAsset(BarrelAsset.SIGN, spigotPosition.getBlock().getType()));
        }
        CompletableFuture<Boolean> output = new CompletableFuture<Boolean>();
        BreweryPlugin.getScheduler().runTask(spigotPosition, () -> output.complete(BarrelAsset.isBarrelAsset(BarrelAsset.SIGN, spigotPosition.getBlock().getType())));
        return output;
    }

    public static Block getSpigotOfSign(Block block) {
        return BarrelBody.getSpigotOfSign(block);
    }

    public static boolean hasDataInWorld(World world) {
        return barrels.containsKey(world.getUID()) && !barrels.get(world.getUID()).isEmpty();
    }

    public static void onUnload(World world) {
        barrels.remove(world.getUID());
    }

    public static void registerBarrel(Barrel barrel) {
        barrels.computeIfAbsent(barrel.spigot.getWorld().getUID(), ignored -> new ArrayList()).add(barrel);
    }

    public static List<Barrel> getAllBarrels() {
        return barrels.values().stream().flatMap(Collection::stream).filter(Objects::nonNull).toList();
    }

    public boolean isSmall() {
        return this.small;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public float getTime() {
        return this.time;
    }

    public UUID getId() {
        return this.id;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public static class BarrelCheck
    extends UniversalRunnable {
        @Override
        public void run() {
            barrels.keySet().forEach(worldUuid -> {
                int counter = checkCounters.computeIfAbsent((UUID)worldUuid, ignored -> -1);
                List<Barrel> worldBarrels = barrels.get(worldUuid);
                if (worldBarrels == null || worldBarrels.isEmpty()) {
                    this.cancel();
                    return;
                }
                counter = (counter + 1) % worldBarrels.size();
                while (counter < worldBarrels.size()) {
                    Barrel barrel = worldBarrels.get(counter++);
                    if (barrel.checked) continue;
                    BreweryPlugin.getScheduler().runTask(barrel.getSpigot().getLocation(), () -> {
                        Block broken = barrel.getBrokenBlock(false);
                        if (broken != null) {
                            Logging.debugLog("Barrel at " + broken.getWorld().getName() + "/" + broken.getX() + "/" + broken.getY() + "/" + broken.getZ() + " has been destroyed unexpectedly, contents will drop");
                            barrel.remove(broken, null, true);
                        } else {
                            barrel.checked = true;
                        }
                    });
                    return;
                }
                this.cancel();
            });
        }
    }
}

