/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BarrelWoodType;
import com.dre.brewery.Brew;
import com.dre.brewery.BrewDefect;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.events.brew.BrewModifyEvent;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.lore.Base91DecoderStream;
import com.dre.brewery.lore.Base91EncoderStream;
import com.dre.brewery.lore.BrewLore;
import com.dre.brewery.recipe.BCauldronRecipe;
import com.dre.brewery.recipe.BRecipe;
import com.dre.brewery.recipe.BestRecipeResult;
import com.dre.brewery.recipe.DebuggableItem;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.recipe.ItemLoader;
import com.dre.brewery.recipe.PotionColor;
import com.dre.brewery.recipe.RecipeEvaluation;
import com.dre.brewery.recipe.RecipeItem;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.MinecraftVersion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.Nullable;

public class BIngredients {
    private static final MinecraftVersion VERSION = BreweryPlugin.getMCVersion();
    private static final BreweryPlugin plugin = BreweryPlugin.getInstance();
    private static final Config config = ConfigManager.getConfig(Config.class);
    private static final Lang lang = ConfigManager.getConfig(Lang.class);
    private static int lastId = 0;
    private int id;
    private List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private int cookedTime;

    public BIngredients() {
    }

    public BIngredients(List<Ingredient> ingredients, int cookedTime) {
        this.ingredients = ingredients;
        this.cookedTime = cookedTime;
    }

    public BIngredients(List<Ingredient> ingredients, int cookedTime, boolean legacy) {
        this(ingredients, cookedTime);
        if (legacy) {
            this.id = lastId++;
        }
    }

    public void add(ItemStack ingredient) {
        for (Ingredient existing : this.ingredients) {
            if (!existing.matches(ingredient)) continue;
            existing.setAmount(existing.getAmount() + 1);
            return;
        }
        Ingredient ing = RecipeItem.getMatchingRecipeItem(ingredient, true).toIngredient(ingredient);
        ing.setAmount(1);
        this.ingredients.add(ing);
    }

    public void add(ItemStack ingredient, RecipeItem rItem) {
        this.add(rItem.toIngredient(ingredient));
    }

    public void addGeneric(RecipeItem rItem) {
        this.add(rItem.toIngredientGeneric());
    }

    private void add(Ingredient ingredient) {
        for (Ingredient existing : this.ingredients) {
            if (!existing.isSimilar(ingredient)) continue;
            existing.setAmount(existing.getAmount() + 1);
            return;
        }
        ingredient.setAmount(1);
        this.ingredients.add(ingredient);
    }

    public ItemStack cook(int state, Player brewer) {
        Brew brew;
        ItemStack potion = new ItemStack(Material.POTION);
        PotionMeta potionMeta = (PotionMeta)potion.getItemMeta();
        assert (potionMeta != null);
        this.cookedTime = state;
        String cookedName = null;
        BRecipe cookRecipe = this.getCookRecipe();
        if (cookRecipe != null) {
            int quality = (int)Math.round((double)(this.getIngredientQuality(cookRecipe) + this.getCookingQuality(cookRecipe, false)) / 2.0);
            int alc = Math.round((float)cookRecipe.getAlcohol() * ((float)quality / 10.0f));
            Logging.debugLog("cooked potion has Quality: " + quality + ", Alc: " + alc);
            brew = new Brew(quality, alc, cookRecipe, this);
            BrewLore lore = new BrewLore(brew, potionMeta);
            lore.updateQualityStars(false);
            lore.updateCustomLore();
            lore.updateAlc(false);
            lore.updateBrewer(brewer == null ? null : brewer.getDisplayName());
            lore.addOrReplaceEffects(brew.getEffects(), brew.getQuality());
            lore.write();
            cookedName = cookRecipe.getName(quality);
            cookRecipe.getColor().colorBrew(potionMeta, potion, false);
            brew.updateCustomModelData((ItemMeta)potionMeta);
            if (cookRecipe.isGlint()) {
                potionMeta.addEnchant(Enchantment.MENDING, 1, true);
                potionMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
        } else {
            brew = new Brew(this);
            if (state <= 0) {
                cookedName = lang.getEntry("Brew_ThickBrew", new Object[0]);
                PotionColor.BLUE.colorBrew(potionMeta, potion, false);
            } else {
                BCauldronRecipe cauldronRecipe = this.getCauldronRecipe();
                if (cauldronRecipe != null) {
                    Logging.debugLog("Found Cauldron Recipe: " + cauldronRecipe.getName());
                    cookedName = cauldronRecipe.getName();
                    if (cauldronRecipe.getLore() != null) {
                        BrewLore lore = new BrewLore(brew, potionMeta);
                        lore.addCauldronLore(cauldronRecipe.getLore());
                        lore.write();
                    }
                    cauldronRecipe.getColor().colorBrew(potionMeta, potion, true);
                    if (VERSION.isOrLater(MinecraftVersion.V1_14) && cauldronRecipe.getCmData() != 0) {
                        potionMeta.setCustomModelData(Integer.valueOf(cauldronRecipe.getCmData()));
                    }
                }
            }
        }
        if (cookedName == null) {
            cookedName = lang.getEntry("Brew_Undefined", new Object[0]);
            PotionColor.CYAN.colorBrew(potionMeta, potion, true);
        }
        potionMeta.setDisplayName(BUtil.color("&f" + cookedName));
        brew.touch();
        BrewModifyEvent modifyEvent = new BrewModifyEvent(brew, (ItemMeta)potionMeta, BrewModifyEvent.Type.FILL, brewer);
        plugin.getServer().getPluginManager().callEvent((Event)modifyEvent);
        if (modifyEvent.isCancelled()) {
            return null;
        }
        brew.save((ItemMeta)potionMeta);
        potion.setItemMeta((ItemMeta)potionMeta);
        plugin.getBreweryStats().metricsForCreate(false);
        return potion;
    }

    public int getIngredientsCount() {
        int count = 0;
        for (Ingredient ing : this.ingredients) {
            count += ing.getAmount();
        }
        return count;
    }

    public List<Ingredient> getIngredientList() {
        return this.ingredients;
    }

    @Nullable
    public BRecipe getBestRecipe(BarrelWoodType wood, float time, boolean distilled) {
        return this.getBestRecipeFull(wood, time, distilled).getSuccessRecipe();
    }

    public BestRecipeResult getBestRecipeFull(BarrelWoodType wood, float time, boolean distilled) {
        if (BRecipe.getAllRecipes().isEmpty()) {
            return new BestRecipeResult.NoRecipesRegistered();
        }
        BRecipe bestRecipe = null;
        RecipeEvaluation bestEval = null;
        float quality = 0.0f;
        BRecipe bestRecipeLegacy = null;
        RecipeEvaluation bestEvalLegacy = null;
        for (BRecipe recipe : BRecipe.getAllRecipes()) {
            RecipeEvaluation completeRecipeEval;
            boolean isFatal;
            RecipeEvaluation ingredientEval = this.getIngredientQualityFull(recipe);
            int ingredientQuality = ingredientEval.getQuality();
            RecipeEvaluation cookingEval = this.getCookingQualityFull(recipe, distilled);
            int cookingQuality = cookingEval.getQuality();
            boolean bl = isFatal = ingredientEval.isFatal() || cookingEval.isFatal();
            if (recipe.needsToAge() || (double)time > 0.5) {
                RecipeEvaluation ageEval = this.getAgeQualityFull(recipe, time);
                int ageQuality = ageEval.getQuality();
                RecipeEvaluation woodEval = this.getWoodQualityFull(recipe, wood);
                int woodQuality = woodEval.getQuality();
                Logging.debugLog("Ingredient Quality: " + ingredientQuality + " Cooking Quality: " + cookingQuality + " Wood Quality: " + woodQuality + " age Quality: " + ageQuality + " for " + recipe.getName(5));
                completeRecipeEval = RecipeEvaluation.combine(ingredientEval, cookingEval, ageEval, woodEval);
                float averageQuality = ((float)ingredientQuality + (float)cookingQuality + (float)woodQuality + (float)ageQuality) / 4.0f;
                if (!isFatal && averageQuality > quality) {
                    quality = ((float)ingredientQuality + (float)cookingQuality + (float)woodQuality + (float)ageQuality) / 4.0f;
                    bestRecipeLegacy = recipe;
                    bestEvalLegacy = completeRecipeEval;
                }
            } else {
                Logging.debugLog("Ingredient Quality: " + ingredientQuality + " Cooking Quality: " + cookingQuality + " for " + recipe.getName(5));
                completeRecipeEval = RecipeEvaluation.combine(ingredientEval, cookingEval);
                float averageQuality = ((float)ingredientQuality + (float)cookingQuality) / 2.0f;
                if (!isFatal && averageQuality > quality) {
                    quality = averageQuality;
                    bestRecipeLegacy = recipe;
                    bestEvalLegacy = completeRecipeEval;
                }
            }
            if (bestEval != null && completeRecipeEval.compareMostToLeastComplexity(bestEval) <= 0) continue;
            bestRecipe = recipe;
            bestEval = completeRecipeEval;
        }
        if (bestRecipeLegacy != null) {
            Logging.debugLog(String.format("best recipe: %s has Quality=%.3f", bestRecipeLegacy.getName(5), Float.valueOf(quality)));
            return new BestRecipeResult.Found(bestRecipeLegacy, bestEvalLegacy);
        }
        Logging.debugLog(String.format("guess recipe: %s has Quality=%.3f", bestRecipe.getName(5), Float.valueOf(bestEval.getTrueQuality())));
        return new BestRecipeResult.Error(bestRecipe, bestEval);
    }

    @Nullable
    public BRecipe getCookRecipe() {
        return this.getCookRecipeFull().getSuccessRecipe();
    }

    public BestRecipeResult getCookRecipeFull() {
        BestRecipeResult result = this.getBestRecipeFull(BarrelWoodType.ANY, 0.0f, false);
        if (result instanceof BestRecipeResult.Found) {
            BestRecipeResult.Found found = (BestRecipeResult.Found)result;
            if (found.recipe().isCookingOnly()) {
                return result;
            }
            RecipeEvaluation eval = found.eval();
            eval.fatal(new BrewDefect.CookingNotNeeded());
            return new BestRecipeResult.Error(found.recipe(), eval);
        }
        return result;
    }

    @Nullable
    public BCauldronRecipe getCauldronRecipe() {
        BCauldronRecipe best = null;
        float bestMatch = 0.0f;
        for (BCauldronRecipe recipe : BCauldronRecipe.getAllRecipes()) {
            float match = recipe.getIngredientMatch(this.ingredients);
            if (match >= 10.0f) {
                return recipe;
            }
            if (!(match > bestMatch)) continue;
            best = recipe;
            bestMatch = match;
        }
        return best;
    }

    @Nullable
    public BRecipe getDistillRecipe(BarrelWoodType wood, float time) {
        return this.getDistillRecipeFull(wood, time).getSuccessRecipe();
    }

    public BestRecipeResult getDistillRecipeFull(BarrelWoodType wood, float time) {
        BestRecipeResult result = this.getBestRecipeFull(wood, time, true);
        if (result instanceof BestRecipeResult.Found) {
            BestRecipeResult.Found found = (BestRecipeResult.Found)result;
            if (found.recipe().needsDistilling()) {
                return result;
            }
            RecipeEvaluation eval = found.eval();
            eval.fatal(new BrewDefect.DistillMismatch(true, false, found.recipe().isAlcoholic()));
            return new BestRecipeResult.Error(found.recipe(), eval);
        }
        return result;
    }

    @Nullable
    public BRecipe getAgeRecipe(BarrelWoodType wood, float time, boolean distilled) {
        return this.getAgeRecipeFull(wood, time, distilled).getSuccessRecipe();
    }

    public BestRecipeResult getAgeRecipeFull(BarrelWoodType wood, float time, boolean distilled) {
        BestRecipeResult result = this.getBestRecipeFull(wood, time, distilled);
        if (result instanceof BestRecipeResult.Found) {
            BestRecipeResult.Found found = (BestRecipeResult.Found)result;
            if (found.recipe().needsToAge()) {
                return result;
            }
            RecipeEvaluation eval = found.eval();
            eval.fatal(new BrewDefect.AgeMismatch(time, found.recipe().getAge(), found.recipe().isAlcoholic()));
            return new BestRecipeResult.Error(found.recipe(), eval);
        }
        return result;
    }

    public int getIngredientQuality(BRecipe recipe) {
        return this.getIngredientQualityFull(recipe).getQuality();
    }

    public RecipeEvaluation getIngredientQualityFull(BRecipe recipe) {
        RecipeEvaluation eval = new RecipeEvaluation();
        List<RecipeItem> missingIngredients = recipe.getMissingIngredients(this.ingredients);
        if (!missingIngredients.isEmpty()) {
            for (RecipeItem missing : missingIngredients) {
                eval.fatal(new BrewDefect.MissingIngredient(missing, missing.getAmount()));
            }
        }
        int badStuff = 0;
        for (Ingredient ingredient : this.ingredients) {
            int amountInRecipe = recipe.amountOf(ingredient);
            int count = ingredient.getAmount();
            if (amountInRecipe == 0) {
                ++badStuff;
                if (count > this.getIngredientsCount() / 2) {
                    eval.fatal(new BrewDefect.WrongIngredient(ingredient));
                    continue;
                }
                if (badStuff < this.ingredients.size()) {
                    float badIngredientDeduction = (float)count * ((float)recipe.getDifficulty() / 2.0f);
                    eval.deduct(new BrewDefect.WrongIngredient(ingredient), badIngredientDeduction);
                    continue;
                }
                eval.fatal(new BrewDefect.WrongIngredient(ingredient));
                continue;
            }
            if (count == amountInRecipe) continue;
            float ingredientCountDeduction = (float)Math.abs(count - amountInRecipe) / (float)recipe.allowedCountDiff(amountInRecipe) * 10.0f;
            eval.deduct(new BrewDefect.WrongCount(ingredient, amountInRecipe), ingredientCountDeduction);
        }
        return eval;
    }

    public int getCookingQuality(BRecipe recipe, boolean distilled) {
        return this.getCookingQualityFull(recipe, distilled).getQuality();
    }

    public RecipeEvaluation getCookingQualityFull(BRecipe recipe, boolean distilled) {
        RecipeEvaluation eval = new RecipeEvaluation();
        if (recipe.needsDistilling() != distilled) {
            eval.fatal(new BrewDefect.DistillMismatch(distilled, recipe.needsDistilling(), recipe.isAlcoholic()));
        }
        if (this.cookedTime < 1) {
            eval.deduct(new BrewDefect.CookTimeMismatch(0, recipe.getCookingTime()), 10.0f);
        } else if (this.cookedTime != recipe.getCookingTime()) {
            float cookTimeDeduction = (float)Math.abs(this.cookedTime - recipe.getCookingTime()) / (float)recipe.allowedTimeDiff(recipe.getCookingTime()) * 10.0f;
            eval.deduct(new BrewDefect.CookTimeMismatch(this.cookedTime, recipe.getCookingTime()), cookTimeDeduction);
        }
        return eval;
    }

    public int getDistillQuality(BRecipe recipe, byte distillRuns) {
        if (recipe.needsDistilling() != distillRuns > 0) {
            return 0;
        }
        return 10 - Math.abs(recipe.getDistillruns() - distillRuns);
    }

    public int getWoodQuality(BRecipe recipe, BarrelWoodType wood) {
        return this.getWoodQualityFull(recipe, wood).getQuality();
    }

    public RecipeEvaluation getWoodQualityFull(BRecipe recipe, BarrelWoodType wood) {
        RecipeEvaluation eval = new RecipeEvaluation();
        if (recipe.usesAnyWood()) {
            return eval;
        }
        if (wood != recipe.getWood()) {
            float woodDeduction = config.isNewBarrelTypeAlgorithm() ? (float)this.getWoodQualityNew(recipe, wood) : recipe.getWoodDiff(wood.getIndex()) * (float)recipe.getDifficulty();
            eval.deduct(new BrewDefect.WrongWood(wood, recipe.getWood()), woodDeduction);
        }
        return eval;
    }

    private int getWoodQualityNew(BRecipe recipe, BarrelWoodType wood) {
        float baseQuality;
        BarrelWoodType recipeWood = recipe.getWood();
        switch (recipeWood.getDistance(wood)) {
            case 0: {
                float f = 10.0f;
                break;
            }
            case 1: {
                float f = 9.0f;
                break;
            }
            case 2: {
                float f = 7.75f;
                break;
            }
            case 3: {
                float f = 6.25f;
                break;
            }
            case 4: {
                float f = 4.5f;
                break;
            }
            case 5: {
                float f = 2.5f;
                break;
            }
            default: {
                float f = baseQuality = 0.0f;
            }
        }
        if (baseQuality == 0.0f) {
            return 0;
        }
        float quality = 10.0f - (10.0f - baseQuality) * 0.5f * (float)recipe.getDifficulty();
        return Math.max(Math.round(quality), 0);
    }

    public int getAgeQuality(BRecipe recipe, float time) {
        return this.getAgeQualityFull(recipe, time).getQuality();
    }

    public RecipeEvaluation getAgeQualityFull(BRecipe recipe, float time) {
        RecipeEvaluation eval = new RecipeEvaluation();
        if (!BUtil.isClose(time, recipe.getAge())) {
            float ageDeduction = Math.abs(time - (float)recipe.getAge()) * ((float)recipe.getDifficulty() / 2.0f);
            eval.deduct(new BrewDefect.AgeMismatch(time, recipe.getAge(), recipe.isAlcoholic()), ageDeduction);
        }
        return eval;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BIngredients)) {
            return false;
        }
        BIngredients other = (BIngredients)obj;
        return this.cookedTime == other.cookedTime && this.ingredients.equals(other.ingredients);
    }

    public BIngredients copy() {
        BIngredients copy = new BIngredients();
        copy.ingredients.addAll(this.ingredients);
        copy.cookedTime = this.cookedTime;
        return copy;
    }

    public String toString() {
        String ingredientsStr = this.ingredients.stream().map(DebuggableItem::debug).collect(Collectors.joining(", ", "[", "]"));
        return new StringJoiner(", ", "BIngredients{", "}").add("cookedTime=" + this.cookedTime).add("ingredients=" + ingredientsStr).toString();
    }

    public void save(DataOutputStream out) throws IOException {
        out.writeInt(this.cookedTime);
        out.writeByte(this.ingredients.size());
        for (Ingredient ing : this.ingredients) {
            ing.saveTo(out);
            out.writeShort(Math.min(ing.getAmount(), Short.MAX_VALUE));
        }
    }

    public static BIngredients load(DataInputStream in, short dataVersion) throws IOException {
        byte size;
        int cookedTime = in.readInt();
        ArrayList<Ingredient> ing = new ArrayList<Ingredient>(size);
        for (size = in.readByte(); size > 0; size = (byte)(size - 1)) {
            ItemLoader itemLoader = new ItemLoader(dataVersion, in, in.readUTF());
            if (!plugin.getIngredientLoaders().containsKey(itemLoader.getSaveID())) {
                Logging.errorLog("Ingredient Loader not found: " + itemLoader.getSaveID());
                break;
            }
            Ingredient loaded = plugin.getIngredientLoaders().get(itemLoader.getSaveID()).apply(itemLoader);
            short amount = in.readShort();
            if (loaded == null) continue;
            loaded.setAmount(amount);
            ing.add(loaded);
        }
        return new BIngredients(ing, cookedTime);
    }

    public int saveLegacy(ConfigurationSection config) {
        String path = "Ingredients." + this.id;
        if (this.cookedTime != 0) {
            config.set(path + ".cookedTime", (Object)this.cookedTime);
        }
        config.set(path + ".mats", (Object)this.serializeIngredients());
        return this.id;
    }

    public String serializeIngredients() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(new Base91EncoderStream(byteStream));){
            out.writeByte(1);
            this.save(out);
        }
        catch (IOException e) {
            Logging.errorLog("Failed to serialize Ingredients", e);
            return "";
        }
        return byteStream.toString();
    }

    public static BIngredients deserializeIngredients(String mat) {
        BIngredients bIngredients;
        DataInputStream in = new DataInputStream(new Base91DecoderStream(new ByteArrayInputStream(mat.getBytes())));
        try {
            byte ver = in.readByte();
            bIngredients = BIngredients.load(in, ver);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Logging.errorLog("Failed to deserialize Ingredients", e);
                return new BIngredients();
            }
        }
        in.close();
        return bIngredients;
    }

    public int getId() {
        return this.id;
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public int getCookedTime() {
        return this.cookedTime;
    }
}

