/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.utility.releases;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.utility.releases.impl.GitHubReleaseChecker;
import com.dre.brewery.utility.releases.impl.GithubSnapshotsReleaseChecker;
import com.dre.brewery.utility.releases.impl.NoImplReleaseChecker;
import com.dre.brewery.utility.releases.impl.SpigotReleaseChecker;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;

public abstract class ReleaseChecker {
    protected static final String CONST_UNRESOLVED = "UNRESOLVED";
    private static ReleaseChecker instance;
    protected String resolvedLatestVersion = "UNRESOLVED";

    public abstract CompletableFuture<String> resolveLatest();

    public abstract CompletableFuture<Boolean> checkForUpdate();

    public abstract String getDownloadURL();

    public void notify(CommandSender receiver) {
        if (receiver.hasPermission("brewery.update") && this.isUpdateAvailable()) {
            Lang lang = ConfigManager.getConfig(Lang.class);
            lang.sendEntry(receiver, "Etc_NewRelease", "v" + this.localVersion(), "v" + this.resolvedLatestVersion, this.getDownloadURL());
        }
    }

    public boolean isUpdateAvailable() {
        if (this.resolvedLatestVersion.equals(CONST_UNRESOLVED)) {
            return false;
        }
        int local = this.parseVersion(this.localVersion());
        int resolved = this.parseVersion(this.resolvedLatestVersion);
        return resolved > local;
    }

    public static ReleaseChecker getInstance(boolean newInstance) {
        if (instance != null && !newInstance) {
            return instance;
        }
        Config config = ConfigManager.getConfig(Config.class);
        switch (config.getResolveUpdatesFrom().ordinal()) {
            case 0: {
                instance = new GitHubReleaseChecker("BreweryTeam", "BreweryX");
                break;
            }
            case 1: {
                instance = new GithubSnapshotsReleaseChecker("BreweryTeam", "BreweryX");
                break;
            }
            case 2: {
                instance = new SpigotReleaseChecker(114777);
                break;
            }
            case 3: {
                instance = new NoImplReleaseChecker();
            }
        }
        return instance;
    }

    public static ReleaseChecker getInstance() {
        return ReleaseChecker.getInstance(false);
    }

    public String localVersion() {
        String versionString = BreweryPlugin.getInstance().getDescription().getVersion();
        if (versionString.contains(";")) {
            return versionString.split(";")[0];
        }
        return versionString;
    }

    public int parseVersion(String version) {
        StringBuilder sb = new StringBuilder();
        for (char c : version.toCharArray()) {
            if (!Character.isDigit(c)) continue;
            sb.append(c);
        }
        return Integer.parseInt(sb.toString());
    }

    public String getResolvedLatestVersion() {
        return this.resolvedLatestVersion;
    }

    public static enum ReleaseCheckerType {
        GITHUB,
        SNAPSHOTS,
        SPIGOT,
        NONE;

    }
}

