/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.utility;

import com.dre.brewery.BCauldron;
import com.dre.brewery.Barrel;
import com.dre.brewery.BarrelAsset;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.events.barrel.BarrelDestroyEvent;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.MaterialUtil;
import com.dre.brewery.utility.MinecraftVersion;
import com.dre.brewery.utility.OptionalFloat;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public final class BUtil {
    private static final String WITH_DELIMITER = "((?<=%1$s)|(?=%1$s))";
    private static final MinecraftVersion VERSION = BreweryPlugin.getMCVersion();
    private static final Pattern RANGE_PATTERN = Pattern.compile("([-+]?\\d+)\\.\\.([-+]?\\d+)");

    public static boolean isChunkLoaded(Block block) {
        return block.getWorld().isChunkLoaded(block.getX() >> 4, block.getZ() >> 4);
    }

    public static String color(String msg) {
        if (msg == null) {
            return null;
        }
        if (msg.isEmpty()) {
            return msg;
        }
        String[] texts = msg.split(String.format(WITH_DELIMITER, "&"));
        StringBuilder finalText = new StringBuilder();
        for (int i = 0; i < texts.length; ++i) {
            if (texts[i].equalsIgnoreCase("&") && texts.length > i + 1) {
                if (texts[++i].charAt(0) == '#') {
                    finalText.append(ChatColor.of((String)texts[i].substring(0, 7))).append(texts[i].substring(7));
                    continue;
                }
                finalText.append(org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)("&" + texts[i])));
                continue;
            }
            finalText.append(texts[i]);
        }
        return finalText.toString();
    }

    public static List<String> colorArrayList(List<String> list) {
        if (list == null) {
            return null;
        }
        return list.stream().map(BUtil::color).toList();
    }

    public static List<String> colorArray(String ... list) {
        if (list == null) {
            return null;
        }
        return Stream.of(list).map(BUtil::color).toList();
    }

    public static Color weightedMixColor(Color prevColor, int prevPos, int currentPos, Color nextColor, int nextPos) {
        float diffPrev = currentPos - prevPos;
        float diffNext = nextPos - currentPos;
        float total = diffNext + diffPrev;
        float percentNext = diffPrev / total;
        float percentPrev = diffNext / total;
        return Color.fromRGB((int)Math.min(255, (int)((float)nextColor.getRed() * percentNext + (float)prevColor.getRed() * percentPrev)), (int)Math.min(255, (int)((float)nextColor.getGreen() * percentNext + (float)prevColor.getGreen() * percentPrev)), (int)Math.min(255, (int)((float)nextColor.getBlue() * percentNext + (float)prevColor.getBlue() * percentPrev)));
    }

    public static void setItemInHand(PlayerInteractEvent event, Material mat, boolean swapped) {
        if (BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_9)) {
            if (event.getHand() == EquipmentSlot.OFF_HAND != swapped) {
                event.getPlayer().getInventory().setItemInOffHand(new ItemStack(mat));
            } else {
                event.getPlayer().getInventory().setItemInMainHand(new ItemStack(mat));
            }
        } else {
            event.getPlayer().setItemInHand(new ItemStack(mat));
        }
    }

    public static Player getPlayerfromString(String nameOrUUID) {
        try {
            return Bukkit.getPlayer((UUID)UUID.fromString(nameOrUUID));
        }
        catch (IllegalArgumentException e) {
            return Bukkit.getPlayerExact((String)nameOrUUID);
        }
    }

    public static void reapplyPotionEffect(Player player, PotionEffect effect, boolean onlyIfStronger) {
        BreweryPlugin.getScheduler().execute((Entity)player, () -> {
            PotionEffectType type = effect.getType();
            if (player.hasPotionEffect(type)) {
                PotionEffect plEffect = VERSION.isOrLater(MinecraftVersion.V1_11) ? player.getPotionEffect(type) : player.getActivePotionEffects().stream().filter(e -> e.getType().equals(type)).findAny().get();
                if (!onlyIfStronger || plEffect.getAmplifier() < effect.getAmplifier() || plEffect.getAmplifier() == effect.getAmplifier() && plEffect.getDuration() < effect.getDuration()) {
                    player.removePotionEffect(type);
                } else {
                    return;
                }
            }
            effect.apply((LivingEntity)player);
        });
    }

    @Nullable
    public static List<String> loadCfgStringList(ConfigurationSection cfg, String path) {
        if (cfg.isString(path)) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(cfg.getString(path));
            return list;
        }
        if (cfg.isList(path)) {
            return cfg.getStringList(path);
        }
        return null;
    }

    public static <T> List<T> getListSafely(Object object) {
        if (object == null) {
            return new ArrayList();
        }
        if (object instanceof List) {
            return (List)object;
        }
        if (object != null) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(object);
            return list;
        }
        return null;
    }

    public static <E extends Enum<E>> List<E> getListSafely(Object object, Class<E> mapToEnum) {
        List list = BUtil.getListSafely(object);
        if (list == null) {
            return null;
        }
        return list.stream().map(it -> BUtil.getEnumByName(mapToEnum, it.toString())).toList();
    }

    public static int indexOfSubstring(List<String> list, String substring) {
        if (list.isEmpty()) {
            return -1;
        }
        int size = list.size();
        for (int index = 0; index < size; ++index) {
            String string = list.get(index);
            if (!string.contains(substring)) continue;
            return index;
        }
        return -1;
    }

    public static int indexOfStart(List<String> list, String lineStart) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!list.get(i).startsWith(lineStart)) continue;
            return i;
        }
        return -1;
    }

    public static String quote(String input) {
        String escaped = input.replace("\\", "\\\\").replace("\"", "\\\"");
        if (input.contains(" ")) {
            return "\"" + escaped + "\"";
        }
        return escaped;
    }

    public static List<String> splitStringKeepingQuotes(String input) {
        return BUtil.splitStringKeepingQuotesVerbose((String)input).strings;
    }

    public static SplitResult splitStringKeepingQuotesVerbose(String input) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean inQuotes = false;
        boolean escape = false;
        for (char c : input.toCharArray()) {
            if (escape) {
                current.append(c);
                escape = false;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (c == ' ' && !inQuotes) {
                if (current.isEmpty()) continue;
                result.add(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(c);
        }
        if (!current.isEmpty()) {
            result.add(current.toString());
        }
        return new SplitResult(result, inQuotes);
    }

    public static String applyPlaceholders(String input, String player, int quality) {
        return input.replaceAll("%player_name%", player).replaceAll("%quality%", String.valueOf(quality));
    }

    public static void createWorldSections(ConfigurationSection section) {
        for (World world : BreweryPlugin.getInstance().getServer().getWorlds()) {
            String worldName = world.getName();
            worldName = worldName.startsWith("DXL_") ? BUtil.getDxlName(worldName) : world.getUID().toString();
            section.createSection(worldName);
        }
    }

    public static boolean blockDestroy(Block block, Player player, BarrelDestroyEvent.Reason reason) {
        Barrel barrel3;
        if (block == null || block.getType() == null) {
            return true;
        }
        Material type = block.getType();
        if (type == Material.CAULDRON || type == MaterialUtil.WATER_CAULDRON) {
            BCauldron.remove(block);
            return true;
        }
        if (BarrelAsset.isBarrelAsset(BarrelAsset.FENCE, type)) {
            Barrel barrel = Barrel.getBySpigot(block);
            if (barrel != null) {
                if (barrel.hasPermsDestroy(player, block, reason)) {
                    barrel.remove(null, player, true);
                    return true;
                }
                return false;
            }
            return true;
        }
        if (BarrelAsset.isBarrelAsset(BarrelAsset.SIGN, type)) {
            Barrel barrel2 = Barrel.getBySpigot(block);
            if (barrel2 != null) {
                if (!barrel2.isLarge()) {
                    if (barrel2.hasPermsDestroy(player, block, reason)) {
                        barrel2.remove(null, player, true);
                        return true;
                    }
                    return false;
                }
                barrel2.destroySign();
            }
            return true;
        }
        if ((BarrelAsset.isBarrelAsset(BarrelAsset.PLANKS, type) || BarrelAsset.isBarrelAsset(BarrelAsset.STAIRS, type)) && (barrel3 = Barrel.getByWood(block)) != null) {
            if (barrel3.hasPermsDestroy(player, block, reason)) {
                barrel3.remove(block, player, true);
            } else {
                return false;
            }
        }
        return true;
    }

    public static void list(CommandSender sender, ArrayList<String> strings, int page) {
        int pages = (int)Math.ceil((float)strings.size() / 7.0f);
        if (page > pages || page < 1) {
            page = 1;
        }
        sender.sendMessage(BUtil.color("&7-------------- &f" + ConfigManager.getConfig(Lang.class).getEntry("Etc_Page", new Object[0]) + " &6" + page + "&f/&6" + pages + " &7--------------"));
        ListIterator<String> iter = strings.listIterator((page - 1) * 7);
        for (int i = 0; i < 7 && iter.hasNext(); ++i) {
            sender.sendMessage(BUtil.color(iter.next()));
        }
    }

    public static Map<Material, Integer> getMaterialMap(List<String> stringList) {
        HashMap<Material, Integer> map = new HashMap<Material, Integer>();
        for (String materialString : stringList) {
            String[] drainSplit = materialString.split("/");
            if (drainSplit.length <= 1) continue;
            Material mat = MaterialUtil.getMaterialSafely(drainSplit[0]);
            int strength = BUtil.parseIntOrZero(drainSplit[1]);
            if (mat == null || strength <= 0) continue;
            map.put(mat, strength);
        }
        return map;
    }

    public static UUID uuidFromString(String uuid) {
        try {
            return UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            Logging.errorLog("UUID is invalid! " + uuid, e);
            return null;
        }
    }

    @Nullable
    public static <E extends Enum<E>> E getEnumByName(Class<E> enumClass, String name) {
        try {
            return Enum.valueOf(enumClass, name.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }

    public static int getItemDespawnRate(World world) {
        YamlConfiguration spigotConfig = Bukkit.spigot().getConfig();
        int worldDespawnRate = spigotConfig.getInt("world-settings." + world.getName() + ".item-despawn-rate", -1);
        if (worldDespawnRate < 0) {
            return spigotConfig.getInt("world-settings.default.item-despawn-rate", 6000);
        }
        return worldDespawnRate;
    }

    public static String getDxlName(String worldName) {
        File dungeonFolder = new File(worldName);
        if (dungeonFolder.isDirectory()) {
            for (File file : dungeonFolder.listFiles()) {
                if (file.isDirectory() || !file.getName().startsWith(".id_")) continue;
                return file.getName().substring(1).toLowerCase();
            }
        }
        return worldName;
    }

    public static List<String> numberRange(int startInclusive, int stopInclusive) {
        return IntStream.range(startInclusive, stopInclusive + 1).mapToObj(String::valueOf).toList();
    }

    public static int getRandomIntInRange(String string) {
        if (string == null) {
            return 0;
        }
        try {
            Matcher matcher = RANGE_PATTERN.matcher(string);
            if (!matcher.matches()) {
                return BUtil.parseIntOrZero(string);
            }
            int lowerBound = Integer.parseInt(matcher.group(1));
            int upperBound = Integer.parseInt(matcher.group(2));
            Random rand = new Random();
            return rand.nextInt(upperBound - lowerBound + 1) + lowerBound;
        }
        catch (NumberFormatException ignored) {
            Logging.debugLog("Could not parse integer range: " + string);
            return 0;
        }
    }

    @Nullable
    public static <T> T choose(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }

    public static <T extends Comparable<T>> List<T> multiMin(Collection<T> collection) {
        ArrayList<Comparable> minValues = new ArrayList<Comparable>();
        Comparable min = null;
        for (Comparable t : collection) {
            if (min == null) {
                min = t;
                minValues.add(t);
                continue;
            }
            int compare = t.compareTo(min);
            if (compare < 0) {
                min = t;
                minValues.clear();
                minValues.add(t);
                continue;
            }
            if (compare != 0) continue;
            minValues.add(t);
        }
        return minValues;
    }

    public static boolean isClose(float a, float b) {
        return (double)Math.abs(a - b) < 1.0E-6;
    }

    public static boolean isInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    public static OptionalInt parseInt(@Nullable String string) {
        if (string == null) {
            return OptionalInt.empty();
        }
        try {
            return OptionalInt.of(Integer.parseInt(string));
        }
        catch (NumberFormatException ignored) {
            return OptionalInt.empty();
        }
    }

    public static OptionalDouble parseDouble(@Nullable String string) {
        if (string == null) {
            return OptionalDouble.empty();
        }
        try {
            double d = Double.parseDouble(string);
            if (Double.isFinite(d)) {
                return OptionalDouble.of(d);
            }
            return OptionalDouble.empty();
        }
        catch (NumberFormatException ignored) {
            return OptionalDouble.empty();
        }
    }

    public static OptionalFloat parseFloat(@Nullable String string) {
        if (string == null) {
            return OptionalFloat.empty();
        }
        try {
            float f = Float.parseFloat(string);
            if (Float.isFinite(f)) {
                return OptionalFloat.of(f);
            }
            return OptionalFloat.empty();
        }
        catch (NumberFormatException ignored) {
            return OptionalFloat.empty();
        }
    }

    public static int parseIntOrZero(@Nullable String string) {
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    public static double parseDoubleOrZero(@Nullable String string) {
        if (string == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException ignored) {
            return 0.0;
        }
    }

    public static float parseFloatOrZero(@Nullable String string) {
        if (string == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException ignored) {
            return 0.0f;
        }
    }

    public record SplitResult(List<String> strings, boolean inQuotes) {
    }
}

