/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.storage.records;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BIngredients;
import com.dre.brewery.storage.DataManager;
import com.dre.brewery.storage.interfaces.SerializableThing;
import com.dre.brewery.utility.BUtil;
import org.bukkit.Location;

public record SerializableCauldron(String id, String serializedLocation, String serializedIngredients, int state) implements SerializableThing
{
    public SerializableCauldron(BCauldron cauldron) {
        this(cauldron.getId().toString(), DataManager.serializeLocation(cauldron.getBlock().getLocation()), cauldron.getIngredients().serializeIngredients(), cauldron.getState());
    }

    public BCauldron toCauldron() {
        Location loc = DataManager.deserializeLocation(this.serializedLocation);
        if (loc == null) {
            return null;
        }
        return new BCauldron(loc.getBlock(), BIngredients.deserializeIngredients(this.serializedIngredients), this.state, BUtil.uuidFromString(this.id));
    }

    @Override
    public String getId() {
        return this.id;
    }
}

