/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.storage.impls;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Wakeup;
import com.dre.brewery.configuration.sector.capsule.ConfiguredDataManager;
import com.dre.brewery.depend.mongodb.client.MongoClient;
import com.dre.brewery.depend.mongodb.client.MongoClients;
import com.dre.brewery.depend.mongodb.client.MongoCollection;
import com.dre.brewery.depend.mongodb.client.MongoDatabase;
import com.dre.brewery.depend.mongodb.client.model.Filters;
import com.dre.brewery.depend.mongodb.client.model.ReplaceOptions;
import com.dre.brewery.storage.DataManager;
import com.dre.brewery.storage.StorageInitException;
import com.dre.brewery.storage.interfaces.SerializableThing;
import com.dre.brewery.storage.records.BreweryMiscData;
import com.dre.brewery.storage.records.SerializableBPlayer;
import com.dre.brewery.storage.records.SerializableBarrel;
import com.dre.brewery.storage.records.SerializableCauldron;
import com.dre.brewery.storage.records.SerializableWakeup;
import com.dre.brewery.utility.FutureUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.jetbrains.annotations.Nullable;

public class MongoDBStorage
extends DataManager {
    private static final String URL = "mongodb+srv://%s:%s@%s/?retryWrites=true&w=majority&appName=BreweryX#%d";
    private static final String[] COLLECTIONS = new String[]{"misc", "barrels", "cauldrons", "players", "wakeups"};
    private static final String MONGO_ID = "_id";
    private final MongoClient mongoClient;
    private final MongoDatabase mongoDatabase;
    private final String collectionPrefix;

    public MongoDBStorage(ConfiguredDataManager record) throws StorageInitException {
        super(record.getType());
        try {
            Logger clientLogger = (Logger)LogManager.getLogger((String)"org.mongodb.driver.client");
            Logger clusterLogger = (Logger)LogManager.getLogger((String)"org.mongodb.driver.cluster");
            if (clientLogger != null) {
                clientLogger.setLevel(Level.ERROR);
            }
            if (clusterLogger != null) {
                clusterLogger.setLevel(Level.ERROR);
            }
            String fullURL = String.format(URL, record.getUsername(), record.getPassword(), record.getAddress(), this.getClass().hashCode());
            this.mongoClient = MongoClients.create(fullURL);
            this.mongoClient.startSession();
            this.mongoDatabase = this.mongoClient.getDatabase(record.getDatabase());
            this.collectionPrefix = record.getTablePrefix();
            for (String collection : COLLECTIONS) {
                this.mongoDatabase.createCollection(this.collectionPrefix + collection);
            }
        }
        catch (Exception e) {
            throw new StorageInitException("Failed to start MongoDB client or get database!", e);
        }
    }

    @Override
    protected void closeConnection() {
        this.mongoClient.close();
    }

    private boolean collectionExists(String name) {
        return this.mongoDatabase.listCollectionNames().into(new ArrayList()).contains(this.collectionPrefix + name);
    }

    @Override
    public boolean createTable(String name, int maxIdLength) {
        if (this.collectionExists(name)) {
            return false;
        }
        this.mongoDatabase.createCollection(this.collectionPrefix + name);
        return true;
    }

    @Override
    public boolean dropTable(String name) {
        if (this.collectionExists(name)) {
            return false;
        }
        this.mongoDatabase.getCollection(this.collectionPrefix + name).drop();
        return true;
    }

    @Override
    public <T extends SerializableThing> T getGeneric(String id, String collection, Class<T> type) {
        MongoCollection<T> mongoCollection = this.mongoDatabase.getCollection(this.collectionPrefix + collection, type);
        return (T)((SerializableThing)mongoCollection.find(Filters.eq(MONGO_ID, id)).first());
    }

    private <T extends SerializableThing> T getGeneric(UUID id, String collection, Class<T> type) {
        return this.getGeneric(id.toString(), collection, type);
    }

    @Override
    public <T extends SerializableThing> List<T> getAllGeneric(String collection, Class<T> type) {
        MongoCollection<T> mongoCollection = this.mongoDatabase.getCollection(this.collectionPrefix + collection, type);
        return mongoCollection.find().into(new ArrayList());
    }

    @Override
    public <T extends SerializableThing> void saveGeneric(T thing, String collection) {
        MongoCollection<?> mongoCollection = this.mongoDatabase.getCollection(this.collectionPrefix + collection, thing.getClass());
        mongoCollection.replaceOne(Filters.eq(MONGO_ID, thing.getId()), thing, new ReplaceOptions().upsert(true));
    }

    @Override
    public <T extends SerializableThing> void saveAllGeneric(List<T> things, String collection, @Nullable Class<T> type) {
        assert (type != null) : "'type' cannot be null when using mongo storage!";
        MongoCollection<T> mongoCollection = this.mongoDatabase.getCollection(this.collectionPrefix + collection, type);
        Set thingsIds = things.stream().map(SerializableThing::getId).collect(Collectors.toSet());
        mongoCollection.deleteMany(Filters.not(Filters.in(MONGO_ID, thingsIds)));
        for (SerializableThing thing : things) {
            mongoCollection.replaceOne(Filters.eq(MONGO_ID, thing.getId()), thing, new ReplaceOptions().upsert(true));
        }
    }

    @Override
    public void deleteGeneric(String id, String collection) {
        MongoCollection<SerializableThing> mongoCollection = this.mongoDatabase.getCollection(this.collectionPrefix + collection, SerializableThing.class);
        mongoCollection.deleteOne(Filters.eq(MONGO_ID, id));
    }

    @Override
    public CompletableFuture<Barrel> getBarrel(UUID id) {
        SerializableBarrel serializableBarrel = this.getGeneric(id, "barrels", SerializableBarrel.class);
        if (serializableBarrel != null) {
            return serializableBarrel.toBarrel();
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<List<Barrel>> getAllBarrels() {
        return FutureUtil.mergeFutures(this.getAllGeneric("barrels", SerializableBarrel.class).stream().map(SerializableBarrel::toBarrel).toList());
    }

    @Override
    public void saveAllBarrels(Collection<Barrel> barrels) {
        List<SerializableBarrel> serializableBarrels = barrels.stream().filter(it -> it.getBounds() != null).map(SerializableBarrel::new).toList();
        this.saveAllGeneric(serializableBarrels, "barrels", SerializableBarrel.class);
    }

    @Override
    public void saveBarrel(Barrel barrel) {
        this.saveGeneric(new SerializableBarrel(barrel), "barrels");
    }

    @Override
    public void deleteBarrel(UUID id) {
        this.deleteGeneric(id.toString(), "barrels");
    }

    @Override
    public BCauldron getCauldron(UUID id) {
        SerializableCauldron serializableCauldron = this.getGeneric(id, "cauldrons", SerializableCauldron.class);
        if (serializableCauldron != null) {
            return serializableCauldron.toCauldron();
        }
        return null;
    }

    @Override
    public Collection<BCauldron> getAllCauldrons() {
        return this.getAllGeneric("cauldrons", SerializableCauldron.class).stream().map(SerializableCauldron::toCauldron).toList();
    }

    @Override
    public void saveAllCauldrons(Collection<BCauldron> cauldrons) {
        List<SerializableCauldron> serializableCauldrons = cauldrons.stream().map(SerializableCauldron::new).toList();
        this.saveAllGeneric(serializableCauldrons, "cauldrons", SerializableCauldron.class);
    }

    @Override
    public void saveCauldron(BCauldron cauldron) {
        this.saveGeneric(new SerializableCauldron(cauldron), "cauldrons");
    }

    @Override
    public void deleteCauldron(UUID id) {
        this.deleteGeneric(id.toString(), "cauldrons");
    }

    @Override
    public BPlayer getPlayer(UUID playerUUID) {
        SerializableBPlayer serializableBPlayer = this.getGeneric(playerUUID, "players", SerializableBPlayer.class);
        if (serializableBPlayer != null) {
            return serializableBPlayer.toBPlayer();
        }
        return null;
    }

    @Override
    public Collection<BPlayer> getAllPlayers() {
        return this.getAllGeneric("players", SerializableBPlayer.class).stream().map(SerializableBPlayer::toBPlayer).toList();
    }

    @Override
    public void saveAllPlayers(Collection<BPlayer> players) {
        List<SerializableBPlayer> serializableBPlayers = players.stream().map(SerializableBPlayer::new).toList();
        this.saveAllGeneric(serializableBPlayers, "players", SerializableBPlayer.class);
    }

    @Override
    public void savePlayer(BPlayer player) {
        this.saveGeneric(new SerializableBPlayer(player), "players");
    }

    @Override
    public void deletePlayer(UUID playerUUID) {
        this.deleteGeneric(playerUUID.toString(), "players");
    }

    @Override
    public Wakeup getWakeup(UUID id) {
        SerializableWakeup serializableWakeup = this.getGeneric(id, "wakeups", SerializableWakeup.class);
        if (serializableWakeup != null) {
            return serializableWakeup.toWakeup();
        }
        return null;
    }

    @Override
    public Collection<Wakeup> getAllWakeups() {
        return this.getAllGeneric("wakeups", SerializableWakeup.class).stream().map(SerializableWakeup::toWakeup).toList();
    }

    @Override
    public void saveAllWakeups(Collection<Wakeup> wakeups) {
        List<SerializableWakeup> serializableWakeups = wakeups.stream().map(SerializableWakeup::new).toList();
        this.saveAllGeneric(serializableWakeups, "wakeups", SerializableWakeup.class);
    }

    @Override
    public void saveWakeup(Wakeup wakeup) {
        this.saveGeneric(new SerializableWakeup(wakeup), "wakeups");
    }

    @Override
    public void deleteWakeup(UUID id) {
        this.deleteGeneric(id.toString(), "wakeups");
    }

    @Override
    public BreweryMiscData getBreweryMiscData() {
        BreweryMiscData data = this.getGeneric("misc", "misc", BreweryMiscData.class);
        if (data != null) {
            return data;
        }
        return new BreweryMiscData(System.currentTimeMillis(), 0L, new ArrayList<Long>(), new ArrayList<Integer>(), 0);
    }

    @Override
    public void saveBreweryMiscData(BreweryMiscData data) {
        this.saveGeneric(data, "misc");
    }
}

