/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.lore;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.utility.NBTUtil;
import java.io.ByteArrayInputStream;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class NBTLoadStream
extends ByteArrayInputStream {
    private static final String TAG = "brewdata";
    private static final NamespacedKey KEY = new NamespacedKey((Plugin)BreweryPlugin.getInstance(), "brewdata");
    private static final NamespacedKey LEGACY_KEY = new NamespacedKey("brewery", "brewdata".toLowerCase());

    public NBTLoadStream(ItemMeta meta) {
        super(NBTLoadStream.getNBTBytes(meta));
    }

    private static byte[] getNBTBytes(ItemMeta meta) {
        byte[] bytes = NBTUtil.readBytesItem(meta, KEY);
        if (bytes == null) {
            bytes = NBTUtil.readBytesItem(meta, LEGACY_KEY);
        }
        if (bytes == null) {
            return new byte[0];
        }
        return bytes;
    }

    public boolean hasData() {
        return this.count > 0;
    }

    public static boolean hasDataInMeta(ItemMeta meta) {
        return NBTUtil.hasBytesItem(meta, KEY) || NBTUtil.hasBytesItem(meta, LEGACY_KEY);
    }
}

