/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.lore;

import java.io.ByteArrayInputStream;
import java.util.List;
import org.bukkit.inventory.meta.ItemMeta;

public class LoreLoadStream
extends ByteArrayInputStream {
    public static final String IDENTIFIER = "\u00a7%";

    public LoreLoadStream(ItemMeta meta) throws IllegalArgumentException {
        this(meta, -1);
    }

    public LoreLoadStream(ItemMeta meta, int line) throws IllegalArgumentException {
        super(LoreLoadStream.loreToBytes(meta, line));
    }

    private static byte[] loreToBytes(ItemMeta meta, int lineNum) throws IllegalArgumentException {
        if (meta.hasLore()) {
            String line;
            List lore = meta.getLore();
            if (lineNum >= 0 && (line = (String)lore.get(lineNum)).startsWith(IDENTIFIER)) {
                return LoreLoadStream.loreLineToBytes(line);
            }
            for (String line2 : lore) {
                if (!line2.startsWith(IDENTIFIER)) continue;
                return LoreLoadStream.loreLineToBytes(line2);
            }
        }
        throw new IllegalArgumentException("Meta has no data in lore");
    }

    private static byte[] loreLineToBytes(String line) {
        StringBuilder build = new StringBuilder((int)((float)line.length() / 2.0f));
        int skip = 2;
        for (char c : line.toCharArray()) {
            if (skip > 0) {
                skip = (byte)(skip - 1);
                continue;
            }
            if (c == '\u00a7') continue;
            build.append(c);
        }
        return build.toString().getBytes();
    }
}

