/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration.listeners.movecraft;

import com.dre.brewery.Barrel;
import com.dre.brewery.integration.listeners.movecraft.MovecraftUtil;
import com.dre.brewery.utility.BoundingBox;
import net.countercraft.movecraft.MovecraftLocation;
import net.countercraft.movecraft.MovecraftRotation;
import net.countercraft.movecraft.craft.Craft;
import net.countercraft.movecraft.events.CraftRotateEvent;
import net.countercraft.movecraft.util.MathUtils;
import net.countercraft.movecraft.util.hitboxes.HitBox;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class RotationListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void craftRotate(CraftRotateEvent event) {
        Craft craft = event.getCraft();
        MovecraftRotation rotation = event.getRotation();
        MovecraftLocation originPoint = event.getOriginPoint();
        HitBox hitBox = craft.getHitBox();
        for (Barrel barrel : MovecraftUtil.barrelsOnCraft(hitBox, craft.getWorld())) {
            this.rotate(barrel, rotation, originPoint);
        }
    }

    public void rotate(Barrel barrel, MovecraftRotation rotation, MovecraftLocation origin) {
        BoundingBox box = barrel.getBounds();
        World world = barrel.getSpigot().getWorld();
        Location spigot = barrel.getSpigot().getLocation();
        MovecraftLocation mvSpigot = MathUtils.bukkit2MovecraftLoc((Location)spigot);
        MovecraftLocation rtSpigot = this.rotateCentered(rotation, mvSpigot, origin);
        barrel.setSpigot(rtSpigot.toBukkit(world).getBlock());
        BoundingBox.BlockPos min = box.getMin();
        MovecraftLocation mvMin = new MovecraftLocation(min.x(), min.y(), min.z());
        MovecraftLocation rtMin = this.rotateCentered(rotation, mvMin, origin);
        BoundingBox.BlockPos bpMin = this.adapt(rtMin);
        BoundingBox.BlockPos max = box.getMax();
        MovecraftLocation mvMax = new MovecraftLocation(max.x(), max.y(), max.z());
        MovecraftLocation rtMax = this.rotateCentered(rotation, mvMax, origin);
        BoundingBox.BlockPos bpMax = this.adapt(rtMax);
        BoundingBox rotatedBox = new BoundingBox(bpMin, bpMax);
        box.setMin(rotatedBox.getMin());
        box.setMax(rotatedBox.getMax());
    }

    public MovecraftLocation rotateCentered(MovecraftRotation rotation, MovecraftLocation subject, MovecraftLocation origin) {
        return MathUtils.rotateVec((MovecraftRotation)rotation, (MovecraftLocation)subject.subtract(origin)).add(origin);
    }

    public BoundingBox.BlockPos adapt(MovecraftLocation ml) {
        return new BoundingBox.BlockPos(ml.getX(), ml.getY(), ml.getZ());
    }
}

