/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration.listeners.movecraft;

import com.dre.brewery.Barrel;
import com.dre.brewery.integration.listeners.movecraft.properties.BreweryProperties;
import com.dre.brewery.integration.listeners.movecraft.properties.MaxBarrelEntry;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.countercraft.movecraft.MovecraftLocation;
import net.countercraft.movecraft.craft.type.CraftType;
import net.countercraft.movecraft.util.MathUtils;
import net.countercraft.movecraft.util.hitboxes.HitBox;
import org.bukkit.Location;
import org.bukkit.World;

public class MovecraftUtil {
    public static Set<Barrel> barrelsOnCraft(HitBox hitBox, World craftWorld) {
        HashSet<Barrel> output = new HashSet<Barrel>();
        for (Barrel barrel : Barrel.getBarrels(craftWorld.getUID())) {
            MovecraftLocation mvLocation;
            Location location = barrel.getSpigot().getLocation();
            if (!Objects.equals(location.getWorld(), craftWorld) || !hitBox.contains(mvLocation = MathUtils.bukkit2MovecraftLoc((Location)location))) continue;
            output.add(barrel);
        }
        return output;
    }

    public static Set<MaxBarrelEntry> getBarrelsProperty(CraftType type) {
        try {
            Object objectProperty = type.getObjectProperty(BreweryProperties.MAX_BARRELS);
            if (objectProperty instanceof Set) {
                Set property = (Set)objectProperty;
                return property;
            }
            throw new IllegalStateException("maxBarrels must be a set.");
        }
        catch (Exception exception) {
            return Set.of();
        }
    }
}

