/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration.listeners;

import com.Acrobot.ChestShop.Events.ShopCreatedEvent;
import com.dre.brewery.Brew;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.integration.Hook;
import com.dre.brewery.utility.Logging;
import org.bukkit.Material;
import org.bukkit.block.Container;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class ChestShopListener
implements Listener {
    private final Lang lang = ConfigManager.getConfig(Lang.class);

    @EventHandler
    public void onShopCreated(ShopCreatedEvent event) {
        try {
            Container container = event.getContainer();
            if (container != null) {
                for (ItemStack item : container.getInventory().getContents()) {
                    Brew brew;
                    if (item == null || item.getType() != Material.POTION || (brew = Brew.get(item)) == null || brew.isSealed()) continue;
                    event.getPlayer().sendTitle("", this.lang.getEntry("Player_ShopSealBrew", new Object[0]), 10, 70, 20);
                    return;
                }
            }
        }
        catch (Throwable e) {
            HandlerList.unregisterAll((Listener)this);
            Hook.CHESTSHOP.setEnabled(false);
            Logging.errorLog("Failed to notify Player using ChestShop. Disabling ChestShop support", e);
        }
    }
}

