/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration.item;

import com.dre.brewery.Brew;
import com.dre.brewery.recipe.BRecipe;
import com.dre.brewery.recipe.PluginItem;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;

public class BreweryPluginItem
extends PluginItem {
    @Override
    public boolean matches(ItemStack item) {
        Brew brew = Brew.get(item);
        if (brew == null) {
            return false;
        }
        return this.isMatchingBrew(brew) || this.isCauldronIngredient(item);
    }

    private boolean isMatchingBrew(Brew brew) {
        BRecipe recipe = brew.getCurrentRecipe();
        if (recipe != null) {
            return this.getItemId().equalsIgnoreCase(recipe.getId()) || this.getItemId().equalsIgnoreCase(recipe.getRecipeName()) || this.getItemId().equalsIgnoreCase(recipe.getName(10));
        }
        return false;
    }

    private boolean isCauldronIngredient(ItemStack item) {
        if (!item.hasItemMeta()) {
            return false;
        }
        return ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).equalsIgnoreCase(this.getItemId());
    }
}

