/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.integration.Hook;
import com.dre.brewery.utility.BUtil;
import me.angeschossen.lands.api.LandsIntegration;
import me.angeschossen.lands.api.flags.enums.FlagTarget;
import me.angeschossen.lands.api.flags.enums.RoleFlagCategory;
import me.angeschossen.lands.api.flags.type.RoleFlag;
import me.angeschossen.lands.api.land.LandWorld;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class LandsHook
extends Hook {
    public static LandsHook LANDS;
    private LandsIntegration landsApi;
    private RoleFlag barrelAccessFlag;

    public static void load() {
        LANDS = new LandsHook("Lands", config.isUseLands());
    }

    public LandsHook(String name, boolean enabled) {
        super(name, enabled);
        if (!enabled) {
            return;
        }
        Lang lang = ConfigManager.getConfig(Lang.class);
        String flag_title = lang.getEntry("Etc_LandsFlag_Title", new Object[0]);
        String[] flag_description = lang.getEntry("Etc_LandsFlag_Description", new Object[0]).split("\\\\n");
        this.landsApi = LandsIntegration.of((Plugin)BreweryPlugin.getInstance());
        this.barrelAccessFlag = (RoleFlag)((RoleFlag)((RoleFlag)((RoleFlag)RoleFlag.of((LandsIntegration)this.landsApi, (FlagTarget)FlagTarget.PLAYER, (RoleFlagCategory)RoleFlagCategory.ACTION, (String)"barrel_access").setDisplayName(BUtil.color(flag_title))).setDescription(BUtil.colorArray(flag_description))).setIcon(new ItemStack(Material.BARREL))).setDisplay(true);
    }

    public boolean hasBarrelAccess(Player player, Location location) {
        if (!this.isEnabled() || location.getWorld() == null) {
            return true;
        }
        LandWorld lWorld = this.landsApi.getWorld(location.getWorld());
        if (lWorld == null) {
            return true;
        }
        return lWorld.hasRoleFlag(player.getUniqueId(), location, this.barrelAccessFlag);
    }
}

