/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.time;

import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.internal.function.CheckedConsumer;
import com.dre.brewery.depend.mongodb.internal.function.CheckedFunction;
import com.dre.brewery.depend.mongodb.internal.function.CheckedRunnable;
import com.dre.brewery.depend.mongodb.internal.function.CheckedSupplier;
import com.dre.brewery.depend.mongodb.internal.thread.InterruptionUtil;
import com.dre.brewery.depend.mongodb.internal.time.TimePoint;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public interface Timeout {
    public static Timeout earliest(Timeout ... timeouts) {
        List<Timeout> list = Arrays.asList(timeouts);
        list.forEach(v -> {
            if (!(v instanceof TimePoint)) {
                throw new AssertionError((Object)"Only TimePoints may be compared");
            }
        });
        return Collections.min(list, (a, b) -> {
            TimePoint tpa = (TimePoint)a;
            TimePoint tpb = (TimePoint)b;
            return tpa.compareTo(tpb);
        });
    }

    public static Timeout infinite() {
        return TimePoint.infinite();
    }

    public static Timeout nullAsInfinite(@Nullable Timeout timeout) {
        return timeout == null ? Timeout.infinite() : timeout;
    }

    @NotNull
    public static Timeout expiresIn(long duration, TimeUnit unit, ZeroSemantics zeroSemantics) {
        if (duration < 0L) {
            throw new AssertionError((Object)"Timeouts must not be in the past");
        }
        if (duration == 0L) {
            switch (zeroSemantics) {
                case ZERO_DURATION_MEANS_INFINITE: {
                    return Timeout.infinite();
                }
                case ZERO_DURATION_MEANS_EXPIRED: {
                    return TimePoint.now();
                }
            }
            throw Assertions.fail("Unknown enum value");
        }
        return TimePoint.now().timeoutAfterOrInfiniteIfNegative(duration, unit);
    }

    public Timeout shortenBy(long var1, TimeUnit var3);

    default public void awaitOn(Condition condition, Supplier<String> action) {
        try {
            this.checkedRun(TimeUnit.NANOSECONDS, () -> condition.await(), ns -> condition.awaitNanos((long)ns), () -> condition.awaitNanos(0L));
        }
        catch (InterruptedException e) {
            throw InterruptionUtil.interruptAndCreateMongoInterruptedException("Interrupted while " + action.get(), e);
        }
    }

    default public void awaitOn(CountDownLatch latch, Supplier<String> action) {
        try {
            this.checkedRun(TimeUnit.NANOSECONDS, () -> latch.await(), ns -> latch.await((long)ns, TimeUnit.NANOSECONDS), () -> latch.await(0L, TimeUnit.NANOSECONDS));
        }
        catch (InterruptedException e) {
            throw InterruptionUtil.interruptAndCreateMongoInterruptedException("Interrupted while " + action.get(), e);
        }
    }

    default public <T> T call(TimeUnit timeUnit, Supplier<T> onInfinite, LongFunction<T> onHasRemaining, Supplier<T> onExpired) {
        return (T)this.checkedCall(timeUnit, onInfinite::get, onHasRemaining::apply, onExpired::get);
    }

    public <T, E extends Exception> T checkedCall(TimeUnit var1, CheckedSupplier<T, E> var2, CheckedFunction<Long, T, E> var3, CheckedSupplier<T, E> var4) throws E;

    default public void run(TimeUnit timeUnit, Runnable onInfinite, LongConsumer onHasRemaining, Runnable onExpired) {
        this.call(timeUnit, () -> {
            onInfinite.run();
            return null;
        }, t -> {
            onHasRemaining.accept(t);
            return null;
        }, () -> {
            onExpired.run();
            return null;
        });
    }

    default public <E extends Exception> void checkedRun(TimeUnit timeUnit, CheckedRunnable<E> onInfinite, CheckedConsumer<Long, E> onHasRemaining, CheckedRunnable<E> onExpired) throws E {
        this.checkedCall(timeUnit, () -> {
            onInfinite.run();
            return null;
        }, t -> {
            onHasRemaining.accept((Long)t);
            return null;
        }, () -> {
            onExpired.run();
            return null;
        });
    }

    default public void onExpired(Runnable onExpired) {
        Timeout.onExistsAndExpired(this, onExpired);
    }

    public static void onExistsAndExpired(@Nullable Timeout t, Runnable onExpired) {
        if (t == null) {
            return;
        }
        t.run(TimeUnit.NANOSECONDS, () -> {}, ns -> {}, () -> onExpired.run());
    }

    public static enum ZeroSemantics {
        ZERO_DURATION_MEANS_EXPIRED,
        ZERO_DURATION_MEANS_INFINITE;

    }
}

