/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonInt32;
import com.dre.brewery.depend.bson.BsonInt64;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.bson.codecs.BsonDocumentCodec;
import com.dre.brewery.depend.bson.codecs.Decoder;
import com.dre.brewery.depend.mongodb.MongoNamespace;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.model.Collation;
import com.dre.brewery.depend.mongodb.internal.async.SingleResultCallback;
import com.dre.brewery.depend.mongodb.internal.binding.AsyncReadBinding;
import com.dre.brewery.depend.mongodb.internal.binding.ReadBinding;
import com.dre.brewery.depend.mongodb.internal.operation.AggregateOperation;
import com.dre.brewery.depend.mongodb.internal.operation.AsyncReadOperation;
import com.dre.brewery.depend.mongodb.internal.operation.ReadOperation;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;

public class CountDocumentsOperation
implements AsyncReadOperation<Long>,
ReadOperation<Long> {
    private static final Decoder<BsonDocument> DECODER = new BsonDocumentCodec();
    private final MongoNamespace namespace;
    private boolean retryReads;
    private BsonDocument filter;
    private BsonValue hint;
    private BsonValue comment;
    private long skip;
    private long limit;
    private Collation collation;

    public CountDocumentsOperation(MongoNamespace namespace) {
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    @Nullable
    public BsonDocument getFilter() {
        return this.filter;
    }

    public CountDocumentsOperation filter(@Nullable BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public CountDocumentsOperation retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    @Nullable
    public BsonValue getHint() {
        return this.hint;
    }

    public CountDocumentsOperation hint(@Nullable BsonValue hint) {
        this.hint = hint;
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public CountDocumentsOperation limit(long limit) {
        this.limit = limit;
        return this;
    }

    public long getSkip() {
        return this.skip;
    }

    public CountDocumentsOperation skip(long skip) {
        this.skip = skip;
        return this;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    public CountDocumentsOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public CountDocumentsOperation comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public Long execute(ReadBinding binding) {
        try (Object cursor = this.getAggregateOperation().execute(binding);){
            Long l = cursor.hasNext() ? this.getCountFromAggregateResults((List<BsonDocument>)cursor.next()) : 0L;
            return l;
        }
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<Long> callback) {
        this.getAggregateOperation().executeAsync(binding, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                result.next((result1, t1) -> {
                    if (t1 != null) {
                        callback.onResult(null, t1);
                    } else {
                        callback.onResult(this.getCountFromAggregateResults((List<BsonDocument>)result1), null);
                    }
                });
            }
        });
    }

    private AggregateOperation<BsonDocument> getAggregateOperation() {
        return new AggregateOperation<BsonDocument>(this.namespace, this.getPipeline(), DECODER).retryReads(this.retryReads).collation(this.collation).comment(this.comment).hint(this.hint);
    }

    private List<BsonDocument> getPipeline() {
        ArrayList<BsonDocument> pipeline = new ArrayList<BsonDocument>();
        pipeline.add(new BsonDocument("$match", this.filter != null ? this.filter : new BsonDocument()));
        if (this.skip > 0L) {
            pipeline.add(new BsonDocument("$skip", new BsonInt64(this.skip)));
        }
        if (this.limit > 0L) {
            pipeline.add(new BsonDocument("$limit", new BsonInt64(this.limit)));
        }
        pipeline.add(new BsonDocument("$group", new BsonDocument("_id", new BsonInt32(1)).append("n", new BsonDocument("$sum", new BsonInt32(1)))));
        return pipeline;
    }

    private Long getCountFromAggregateResults(@Nullable List<BsonDocument> results) {
        if (results == null || results.isEmpty()) {
            return 0L;
        }
        return results.get(0).getNumber("n").longValue();
    }
}

