/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonDocumentWrapper;
import com.dre.brewery.depend.bson.BsonReader;
import com.dre.brewery.depend.bson.BsonType;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.bson.codecs.BsonDocumentCodec;
import com.dre.brewery.depend.bson.codecs.Codec;
import com.dre.brewery.depend.bson.codecs.Decoder;
import com.dre.brewery.depend.bson.codecs.DecoderContext;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistries;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistry;
import com.dre.brewery.depend.mongodb.internal.operation.CommandResultArrayCodec;
import com.dre.brewery.depend.mongodb.internal.operation.CommandResultCodecProvider;
import java.util.Collections;
import java.util.List;

class CommandResultDocumentCodec<T>
extends BsonDocumentCodec {
    private final Decoder<T> payloadDecoder;
    private final List<String> fieldsContainingPayload;

    CommandResultDocumentCodec(CodecRegistry registry, Decoder<T> payloadDecoder, List<String> fieldsContainingPayload) {
        super(registry);
        this.payloadDecoder = payloadDecoder;
        this.fieldsContainingPayload = fieldsContainingPayload;
    }

    static <P> Codec<BsonDocument> create(Decoder<P> decoder, String fieldContainingPayload) {
        return CommandResultDocumentCodec.create(decoder, Collections.singletonList(fieldContainingPayload));
    }

    static <P> Codec<BsonDocument> create(Decoder<P> decoder, List<String> fieldsContainingPayload) {
        CodecRegistry registry = CodecRegistries.fromProviders(new CommandResultCodecProvider<P>(decoder, fieldsContainingPayload));
        return registry.get(BsonDocument.class);
    }

    @Override
    protected BsonValue readValue(BsonReader reader, DecoderContext decoderContext) {
        if (this.fieldsContainingPayload.contains(reader.getCurrentName())) {
            if (reader.getCurrentBsonType() == BsonType.DOCUMENT) {
                return new BsonDocumentWrapper<T>(this.payloadDecoder.decode(reader, decoderContext), null);
            }
            if (reader.getCurrentBsonType() == BsonType.ARRAY) {
                return new CommandResultArrayCodec<T>(this.getCodecRegistry(), this.payloadDecoder).decode(reader, decoderContext);
            }
        }
        return super.readValue(reader, decoderContext);
    }
}

