/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.bson.BsonArray;
import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonInt32;
import com.dre.brewery.depend.bson.BsonInt64;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.mongodb.MongoCommandException;
import com.dre.brewery.depend.mongodb.MongoCursorNotFoundException;
import com.dre.brewery.depend.mongodb.MongoNamespace;
import com.dre.brewery.depend.mongodb.MongoQueryException;
import com.dre.brewery.depend.mongodb.ServerCursor;
import com.dre.brewery.depend.mongodb.connection.ConnectionDescription;
import com.dre.brewery.depend.mongodb.internal.operation.CommandCursorResult;
import com.dre.brewery.depend.mongodb.internal.operation.DocumentHelper;
import com.dre.brewery.depend.mongodb.internal.operation.OperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.ServerVersionHelper;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.Collections;

final class CommandBatchCursorHelper {
    static final String FIRST_BATCH = "firstBatch";
    static final String NEXT_BATCH = "nextBatch";
    static final String MESSAGE_IF_CLOSED_AS_CURSOR = "Cursor has been closed";
    static final String MESSAGE_IF_CLOSED_AS_ITERATOR = "Iterator has been closed";
    static final String MESSAGE_IF_CONCURRENT_OPERATION = "Another operation is currently in progress, concurrent operations are not supported";

    static BsonDocument getMoreCommandDocument(long cursorId, ConnectionDescription connectionDescription, MongoNamespace namespace, int batchSize, @Nullable BsonValue comment) {
        BsonDocument document = new BsonDocument("getMore", new BsonInt64(cursorId)).append("collection", new BsonString(namespace.getCollectionName()));
        if (batchSize != 0) {
            document.append("batchSize", new BsonInt32(batchSize));
        }
        if (ServerVersionHelper.serverIsAtLeastVersionFourDotFour(connectionDescription)) {
            DocumentHelper.putIfNotNull(document, "comment", comment);
        }
        return document;
    }

    static <T> CommandCursorResult<T> logCommandCursorResult(CommandCursorResult<T> commandCursorResult) {
        if (OperationHelper.LOGGER.isDebugEnabled()) {
            OperationHelper.LOGGER.debug(String.format("Received batch of %d documents with cursorId %d from server %s", commandCursorResult.getResults().size(), commandCursorResult.getCursorId(), commandCursorResult.getServerAddress()));
        }
        return commandCursorResult;
    }

    static BsonDocument getKillCursorsCommand(MongoNamespace namespace, ServerCursor serverCursor) {
        return new BsonDocument("killCursors", new BsonString(namespace.getCollectionName())).append("cursors", new BsonArray(Collections.singletonList(new BsonInt64(serverCursor.getId()))));
    }

    static MongoQueryException translateCommandException(MongoCommandException commandException, ServerCursor cursor) {
        if (commandException.getErrorCode() == 43) {
            return new MongoCursorNotFoundException(cursor.getId(), commandException.getResponse(), cursor.getAddress());
        }
        return new MongoQueryException(commandException.getResponse(), commandException.getServerAddress());
    }

    private CommandBatchCursorHelper() {
    }
}

