/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.mongodb.AuthenticationMechanism;
import com.dre.brewery.depend.mongodb.MongoCredential;
import com.dre.brewery.depend.mongodb.MongoSecurityException;
import com.dre.brewery.depend.mongodb.ServerAddress;
import com.dre.brewery.depend.mongodb.ServerApi;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ClusterConnectionMode;
import com.dre.brewery.depend.mongodb.internal.connection.MongoCredentialWithCache;
import com.dre.brewery.depend.mongodb.internal.connection.SaslAuthenticator;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

class PlainAuthenticator
extends SaslAuthenticator {
    private static final String DEFAULT_PROTOCOL = "mongodb";

    PlainAuthenticator(MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(credential, clusterConnectionMode, serverApi);
    }

    @Override
    public String getMechanismName() {
        return AuthenticationMechanism.PLAIN.getMechanismName();
    }

    @Override
    protected SaslClient createSaslClient(ServerAddress serverAddress) {
        MongoCredential credential = this.getMongoCredential();
        Assertions.isTrue("mechanism is PLAIN", credential.getAuthenticationMechanism() == AuthenticationMechanism.PLAIN);
        try {
            return Sasl.createSaslClient(new String[]{AuthenticationMechanism.PLAIN.getMechanismName()}, credential.getUserName(), DEFAULT_PROTOCOL, serverAddress.getHost(), null, callbacks -> {
                for (Callback callback : callbacks) {
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)callback).setPassword(credential.getPassword());
                        continue;
                    }
                    if (!(callback instanceof NameCallback)) continue;
                    ((NameCallback)callback).setName(credential.getUserName());
                }
            });
        }
        catch (SaslException e) {
            throw new MongoSecurityException(credential, "Exception initializing SASL client", (Throwable)e);
        }
    }
}

