/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.mongodb.MongoClientException;
import com.dre.brewery.depend.mongodb.MongoException;
import com.dre.brewery.depend.mongodb.MongoInterruptedException;
import com.dre.brewery.depend.mongodb.MongoOperationTimeoutException;
import com.dre.brewery.depend.mongodb.MongoTimeoutException;
import com.dre.brewery.depend.mongodb.ServerAddress;
import com.dre.brewery.depend.mongodb.annotations.ThreadSafe;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ClusterConnectionMode;
import com.dre.brewery.depend.mongodb.connection.ClusterDescription;
import com.dre.brewery.depend.mongodb.connection.ClusterId;
import com.dre.brewery.depend.mongodb.connection.ClusterSettings;
import com.dre.brewery.depend.mongodb.connection.ClusterType;
import com.dre.brewery.depend.mongodb.connection.ServerConnectionState;
import com.dre.brewery.depend.mongodb.connection.ServerDescription;
import com.dre.brewery.depend.mongodb.connection.ServerType;
import com.dre.brewery.depend.mongodb.event.ClusterClosedEvent;
import com.dre.brewery.depend.mongodb.event.ClusterDescriptionChangedEvent;
import com.dre.brewery.depend.mongodb.event.ClusterListener;
import com.dre.brewery.depend.mongodb.event.ClusterOpeningEvent;
import com.dre.brewery.depend.mongodb.event.ServerDescriptionChangedEvent;
import com.dre.brewery.depend.mongodb.internal.Locks;
import com.dre.brewery.depend.mongodb.internal.TimeoutContext;
import com.dre.brewery.depend.mongodb.internal.async.SingleResultCallback;
import com.dre.brewery.depend.mongodb.internal.connection.BaseCluster;
import com.dre.brewery.depend.mongodb.internal.connection.Cluster;
import com.dre.brewery.depend.mongodb.internal.connection.ClusterClock;
import com.dre.brewery.depend.mongodb.internal.connection.ClusterableServer;
import com.dre.brewery.depend.mongodb.internal.connection.ClusterableServerFactory;
import com.dre.brewery.depend.mongodb.internal.connection.DnsSrvRecordInitializer;
import com.dre.brewery.depend.mongodb.internal.connection.DnsSrvRecordMonitor;
import com.dre.brewery.depend.mongodb.internal.connection.DnsSrvRecordMonitorFactory;
import com.dre.brewery.depend.mongodb.internal.connection.OperationContext;
import com.dre.brewery.depend.mongodb.internal.connection.ServerTuple;
import com.dre.brewery.depend.mongodb.internal.diagnostics.logging.Logger;
import com.dre.brewery.depend.mongodb.internal.diagnostics.logging.Loggers;
import com.dre.brewery.depend.mongodb.internal.event.EventListenerHelper;
import com.dre.brewery.depend.mongodb.internal.time.Timeout;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import com.dre.brewery.depend.mongodb.selector.ServerSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@ThreadSafe
final class LoadBalancedCluster
implements Cluster {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private final ClusterId clusterId;
    private final ClusterSettings settings;
    private final ClusterClock clusterClock = new ClusterClock();
    private final ClusterListener clusterListener;
    private ClusterDescription description;
    @Nullable
    private ClusterableServer server;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final DnsSrvRecordMonitor dnsSrvRecordMonitor;
    private volatile MongoException srvResolutionException;
    private boolean srvRecordResolvedToMultipleHosts;
    private volatile boolean initializationCompleted;
    private List<ServerSelectionRequest> waitQueue = new LinkedList<ServerSelectionRequest>();
    private Thread waitQueueHandler;
    private final Lock lock = new ReentrantLock(true);
    private final Condition condition = this.lock.newCondition();

    LoadBalancedCluster(final ClusterId clusterId, ClusterSettings settings, final ClusterableServerFactory serverFactory, DnsSrvRecordMonitorFactory dnsSrvRecordMonitorFactory) {
        Assertions.assertTrue(settings.getMode() == ClusterConnectionMode.LOAD_BALANCED);
        LOGGER.info(String.format("Cluster created with id %s and settings %s", clusterId, settings.getShortDescription()));
        this.clusterId = clusterId;
        this.settings = settings;
        this.clusterListener = EventListenerHelper.singleClusterListener(settings);
        this.description = new ClusterDescription(settings.getMode(), ClusterType.UNKNOWN, Collections.emptyList(), settings, serverFactory.getSettings());
        if (settings.getSrvHost() == null) {
            this.dnsSrvRecordMonitor = null;
            this.init(clusterId, serverFactory, settings.getHosts().get(0));
            this.initializationCompleted = true;
        } else {
            Assertions.notNull("dnsSrvRecordMonitorFactory", dnsSrvRecordMonitorFactory);
            this.dnsSrvRecordMonitor = dnsSrvRecordMonitorFactory.create(Assertions.assertNotNull(settings.getSrvHost()), settings.getSrvServiceName(), new DnsSrvRecordInitializer(){

                @Override
                public void initialize(Collection<ServerAddress> hosts) {
                    List localWaitQueue;
                    LOGGER.info("SRV resolution completed with hosts: " + hosts);
                    LoadBalancedCluster.this.lock.lock();
                    try {
                        if (LoadBalancedCluster.this.isClosed()) {
                            return;
                        }
                        LoadBalancedCluster.this.srvResolutionException = null;
                        if (hosts.size() != 1) {
                            LoadBalancedCluster.this.srvRecordResolvedToMultipleHosts = true;
                        } else {
                            LoadBalancedCluster.this.init(clusterId, serverFactory, hosts.iterator().next());
                        }
                        LoadBalancedCluster.this.initializationCompleted = true;
                        localWaitQueue = LoadBalancedCluster.this.waitQueue;
                        LoadBalancedCluster.this.waitQueue = Collections.emptyList();
                        LoadBalancedCluster.this.condition.signalAll();
                    }
                    finally {
                        LoadBalancedCluster.this.lock.unlock();
                    }
                    localWaitQueue.forEach(request -> LoadBalancedCluster.this.handleServerSelectionRequest(request));
                }

                @Override
                public void initialize(MongoException initializationException) {
                    LoadBalancedCluster.this.srvResolutionException = initializationException;
                }

                @Override
                public ClusterType getClusterType() {
                    return LoadBalancedCluster.this.initializationCompleted ? ClusterType.LOAD_BALANCED : ClusterType.UNKNOWN;
                }
            });
            this.dnsSrvRecordMonitor.start();
        }
    }

    private void init(ClusterId clusterId, ClusterableServerFactory serverFactory, ServerAddress host) {
        this.clusterListener.clusterOpening(new ClusterOpeningEvent(clusterId));
        ClusterDescription initialDescription = new ClusterDescription(this.settings.getMode(), ClusterType.LOAD_BALANCED, Collections.singletonList(ServerDescription.builder().address(this.settings.getHosts().get(0)).state(ServerConnectionState.CONNECTING).build()), this.settings, serverFactory.getSettings());
        this.clusterListener.clusterDescriptionChanged(new ClusterDescriptionChangedEvent(clusterId, initialDescription, this.description));
        this.description = new ClusterDescription(ClusterConnectionMode.LOAD_BALANCED, ClusterType.LOAD_BALANCED, Collections.singletonList(ServerDescription.builder().ok(true).state(ServerConnectionState.CONNECTED).type(ServerType.LOAD_BALANCER).address(host).build()), this.settings, serverFactory.getSettings());
        this.server = serverFactory.create(this, host);
        this.clusterListener.clusterDescriptionChanged(new ClusterDescriptionChangedEvent(clusterId, this.description, initialDescription));
    }

    @Override
    public ClusterSettings getSettings() {
        Assertions.isTrue("open", !this.isClosed());
        return this.settings;
    }

    @Override
    public ClusterId getClusterId() {
        return this.clusterId;
    }

    @Override
    public Cluster.ServersSnapshot getServersSnapshot(Timeout serverSelectionTimeout, TimeoutContext timeoutContext) {
        Assertions.isTrue("open", !this.isClosed());
        this.waitForSrv(serverSelectionTimeout, timeoutContext);
        ClusterableServer server = Assertions.assertNotNull(this.server);
        return serverAddress -> server;
    }

    @Override
    public ClusterDescription getCurrentDescription() {
        Assertions.isTrue("open", !this.isClosed());
        return this.description;
    }

    @Override
    public ClusterClock getClock() {
        Assertions.isTrue("open", !this.isClosed());
        return this.clusterClock;
    }

    @Override
    public ServerTuple selectServer(ServerSelector serverSelector, OperationContext operationContext) {
        Assertions.isTrue("open", !this.isClosed());
        Timeout computedServerSelectionTimeout = operationContext.getTimeoutContext().computeServerSelectionTimeout();
        this.waitForSrv(computedServerSelectionTimeout, operationContext.getTimeoutContext());
        if (this.srvRecordResolvedToMultipleHosts) {
            throw this.createResolvedToMultipleHostsException();
        }
        ClusterDescription curDescription = this.description;
        BaseCluster.logServerSelectionStarted(this.clusterId, operationContext.getId(), serverSelector, curDescription);
        ServerTuple serverTuple = new ServerTuple(Assertions.assertNotNull(this.server), curDescription.getServerDescriptions().get(0));
        BaseCluster.logServerSelectionSucceeded(this.clusterId, operationContext.getId(), serverTuple.getServerDescription().getAddress(), serverSelector, curDescription);
        return serverTuple;
    }

    private void waitForSrv(Timeout serverSelectionTimeout, TimeoutContext timeoutContext) {
        if (this.initializationCompleted) {
            return;
        }
        Locks.withLock(this.lock, () -> {
            while (!this.initializationCompleted) {
                if (this.isClosed()) {
                    throw this.createShutdownException();
                }
                serverSelectionTimeout.onExpired(() -> {
                    throw this.createTimeoutException(timeoutContext);
                });
                serverSelectionTimeout.awaitOn(this.condition, () -> String.format("resolving SRV records for %s", this.settings.getSrvHost()));
            }
        });
    }

    @Override
    public void selectServerAsync(ServerSelector serverSelector, OperationContext operationContext, SingleResultCallback<ServerTuple> callback) {
        if (this.isClosed()) {
            callback.onResult(null, this.createShutdownException());
            return;
        }
        Timeout computedServerSelectionTimeout = operationContext.getTimeoutContext().computeServerSelectionTimeout();
        ServerSelectionRequest serverSelectionRequest = new ServerSelectionRequest(operationContext.getId(), serverSelector, operationContext, computedServerSelectionTimeout, callback);
        if (this.initializationCompleted) {
            this.handleServerSelectionRequest(serverSelectionRequest);
        } else {
            this.notifyWaitQueueHandler(serverSelectionRequest);
        }
    }

    private MongoClientException createShutdownException() {
        return new MongoClientException("Shutdown in progress");
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            ClusterableServer localServer;
            LOGGER.info(String.format("Cluster closed with id %s", this.clusterId));
            if (this.dnsSrvRecordMonitor != null) {
                this.dnsSrvRecordMonitor.close();
            }
            if ((localServer = Locks.withLock(this.lock, () -> {
                this.condition.signalAll();
                return this.server;
            })) != null) {
                localServer.close();
            }
            this.clusterListener.clusterClosed(new ClusterClosedEvent(this.clusterId));
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void withLock(Runnable action) {
        Assertions.fail();
    }

    @Override
    public void onChange(ServerDescriptionChangedEvent event) {
        Assertions.fail();
    }

    private void handleServerSelectionRequest(ServerSelectionRequest serverSelectionRequest) {
        Assertions.assertTrue(this.initializationCompleted);
        if (this.srvRecordResolvedToMultipleHosts) {
            serverSelectionRequest.onError(this.createResolvedToMultipleHostsException());
        } else {
            ClusterDescription curDescription = this.description;
            BaseCluster.logServerSelectionStarted(this.clusterId, serverSelectionRequest.operationId, serverSelectionRequest.serverSelector, curDescription);
            ServerTuple serverTuple = new ServerTuple(Assertions.assertNotNull(this.server), curDescription.getServerDescriptions().get(0));
            BaseCluster.logServerSelectionSucceeded(this.clusterId, serverSelectionRequest.operationId, serverTuple.getServerDescription().getAddress(), serverSelectionRequest.serverSelector, curDescription);
            serverSelectionRequest.onSuccess(serverTuple);
        }
    }

    private MongoClientException createResolvedToMultipleHostsException() {
        return new MongoClientException("In load balancing mode, the host must resolve to a single SRV record, but instead it resolved to multiple hosts");
    }

    private MongoTimeoutException createTimeoutException(TimeoutContext timeoutContext) {
        MongoException localSrvResolutionException = this.srvResolutionException;
        String message = localSrvResolutionException == null ? String.format("Timed out while waiting to resolve SRV records for %s.", this.settings.getSrvHost()) : String.format("Timed out while waiting to resolve SRV records for %s. Resolution exception was '%s'", this.settings.getSrvHost(), localSrvResolutionException);
        return LoadBalancedCluster.createTimeoutException(timeoutContext, message);
    }

    private static MongoTimeoutException createTimeoutException(TimeoutContext timeoutContext, String message) {
        return timeoutContext.hasTimeoutMS() ? new MongoOperationTimeoutException(message) : new MongoTimeoutException(message);
    }

    private void notifyWaitQueueHandler(ServerSelectionRequest request) {
        Locks.withLock(this.lock, () -> {
            if (this.isClosed()) {
                request.onError(this.createShutdownException());
                return;
            }
            if (this.initializationCompleted) {
                this.handleServerSelectionRequest(request);
                return;
            }
            this.waitQueue.add(request);
            if (this.waitQueueHandler == null) {
                this.waitQueueHandler = new Thread((Runnable)new WaitQueueHandler(), "cluster-" + this.clusterId.getValue());
                this.waitQueueHandler.setDaemon(true);
                this.waitQueueHandler.start();
            } else {
                this.condition.signalAll();
            }
        });
    }

    private static final class ServerSelectionRequest {
        private final long operationId;
        private final ServerSelector serverSelector;
        private final SingleResultCallback<ServerTuple> callback;
        private final Timeout timeout;
        private final OperationContext operationContext;

        private ServerSelectionRequest(long operationId, ServerSelector serverSelector, OperationContext operationContext, Timeout timeout, SingleResultCallback<ServerTuple> callback) {
            this.operationId = operationId;
            this.serverSelector = serverSelector;
            this.timeout = timeout;
            this.operationContext = operationContext;
            this.callback = callback;
        }

        Timeout getTimeout() {
            return this.timeout;
        }

        OperationContext getOperationContext() {
            return this.operationContext;
        }

        public void onSuccess(ServerTuple serverTuple) {
            try {
                this.callback.onResult(serverTuple, null);
            }
            catch (Exception e) {
                LOGGER.warn("Unanticipated exception thrown from callback", e);
            }
        }

        public void onError(Throwable exception) {
            try {
                this.callback.onResult(null, exception);
            }
            catch (Exception e) {
                LOGGER.warn("Unanticipated exception thrown from callback", e);
            }
        }
    }

    private final class WaitQueueHandler
    implements Runnable {
        private WaitQueueHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList timeoutList = new ArrayList();
            while (!LoadBalancedCluster.this.isClosed() && !LoadBalancedCluster.this.initializationCompleted) {
                LoadBalancedCluster.this.lock.lock();
                try {
                    if (LoadBalancedCluster.this.isClosed() || LoadBalancedCluster.this.initializationCompleted) break;
                    Timeout waitTimeNanos = Timeout.infinite();
                    Iterator iterator = LoadBalancedCluster.this.waitQueue.iterator();
                    while (iterator.hasNext()) {
                        ServerSelectionRequest next = (ServerSelectionRequest)iterator.next();
                        Timeout nextTimeout = next.getTimeout();
                        Timeout waitTimeNanosFinal = waitTimeNanos;
                        waitTimeNanos = nextTimeout.call(TimeUnit.NANOSECONDS, () -> Timeout.earliest(waitTimeNanosFinal, nextTimeout), ns -> Timeout.earliest(waitTimeNanosFinal, nextTimeout), () -> {
                            timeoutList.add(next);
                            iterator.remove();
                            return waitTimeNanosFinal;
                        });
                    }
                    if (timeoutList.isEmpty()) {
                        try {
                            waitTimeNanos.awaitOn(LoadBalancedCluster.this.condition, () -> "ignored");
                        }
                        catch (MongoInterruptedException unexpected) {
                            Assertions.fail();
                        }
                    }
                }
                finally {
                    LoadBalancedCluster.this.lock.unlock();
                }
                timeoutList.forEach(request -> request.onError(LoadBalancedCluster.this.createTimeoutException(request.getOperationContext().getTimeoutContext())));
                timeoutList.clear();
            }
            List shutdownList = Locks.withLock(LoadBalancedCluster.this.lock, () -> {
                ArrayList result = new ArrayList(LoadBalancedCluster.this.waitQueue);
                LoadBalancedCluster.this.waitQueue.clear();
                return result;
            });
            shutdownList.forEach(request -> request.onError(LoadBalancedCluster.this.createShutdownException()));
        }
    }
}

