/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.mongodb.connection.ClusterId;
import com.dre.brewery.depend.mongodb.connection.ServerSettings;
import com.dre.brewery.depend.mongodb.internal.connection.DefaultDnsSrvRecordMonitor;
import com.dre.brewery.depend.mongodb.internal.connection.DnsSrvRecordInitializer;
import com.dre.brewery.depend.mongodb.internal.connection.DnsSrvRecordMonitor;
import com.dre.brewery.depend.mongodb.internal.connection.DnsSrvRecordMonitorFactory;
import com.dre.brewery.depend.mongodb.internal.dns.DefaultDnsResolver;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import com.dre.brewery.depend.mongodb.spi.dns.DnsClient;
import java.util.concurrent.TimeUnit;

public class DefaultDnsSrvRecordMonitorFactory
implements DnsSrvRecordMonitorFactory {
    private static final long DEFAULT_RESCAN_FREQUENCY_MILLIS = 60000L;
    private final ClusterId clusterId;
    private final long noRecordsRescanFrequency;
    private final DnsClient dnsClient;

    public DefaultDnsSrvRecordMonitorFactory(ClusterId clusterId, ServerSettings serverSettings, @Nullable DnsClient dnsClient) {
        this.clusterId = clusterId;
        this.noRecordsRescanFrequency = serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS);
        this.dnsClient = dnsClient;
    }

    @Override
    public DnsSrvRecordMonitor create(String hostName, String srvServiceName, DnsSrvRecordInitializer dnsSrvRecordInitializer) {
        return new DefaultDnsSrvRecordMonitor(hostName, srvServiceName, 60000L, this.noRecordsRescanFrequency, dnsSrvRecordInitializer, this.clusterId, new DefaultDnsResolver(this.dnsClient));
    }
}

