/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.bson.BsonBinary;
import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonInt32;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.bson.RawBsonDocument;
import com.dre.brewery.depend.mongodb.AuthenticationMechanism;
import com.dre.brewery.depend.mongodb.AwsCredential;
import com.dre.brewery.depend.mongodb.MongoClientException;
import com.dre.brewery.depend.mongodb.MongoCredential;
import com.dre.brewery.depend.mongodb.MongoException;
import com.dre.brewery.depend.mongodb.ServerAddress;
import com.dre.brewery.depend.mongodb.ServerApi;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ClusterConnectionMode;
import com.dre.brewery.depend.mongodb.internal.authentication.AwsCredentialHelper;
import com.dre.brewery.depend.mongodb.internal.connection.AuthorizationHeader;
import com.dre.brewery.depend.mongodb.internal.connection.MongoCredentialWithCache;
import com.dre.brewery.depend.mongodb.internal.connection.SaslAuthenticator;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class AwsAuthenticator
extends SaslAuthenticator {
    private static final String MONGODB_AWS_MECHANISM_NAME = "MONGODB-AWS";
    private static final int RANDOM_LENGTH = 32;

    public AwsAuthenticator(MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(credential, clusterConnectionMode, serverApi);
        if (this.getMongoCredential().getAuthenticationMechanism() != AuthenticationMechanism.MONGODB_AWS) {
            throw new MongoException("Incorrect mechanism: " + this.getMongoCredential().getMechanism());
        }
    }

    @Override
    public String getMechanismName() {
        return MONGODB_AWS_MECHANISM_NAME;
    }

    @Override
    protected SaslClient createSaslClient(ServerAddress serverAddress) {
        return new AwsSaslClient(this.getMongoCredential());
    }

    private static class AwsSaslClient
    extends SaslAuthenticator.SaslClientImpl {
        private final byte[] clientNonce = new byte[32];
        private int step = -1;

        AwsSaslClient(MongoCredential credential) {
            super(credential);
        }

        @Override
        public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
            ++this.step;
            if (this.step == 0) {
                return this.computeClientFirstMessage();
            }
            if (this.step == 1) {
                return this.computeClientFinalMessage(challenge);
            }
            throw new SaslException(String.format("Too many steps involved in the %s negotiation.", this.getMechanismName()));
        }

        @Override
        public boolean isComplete() {
            return this.step == 1;
        }

        private byte[] computeClientFirstMessage() {
            new SecureRandom().nextBytes(this.clientNonce);
            BsonDocument document = new BsonDocument().append("r", new BsonBinary(this.clientNonce)).append("p", new BsonInt32(110));
            return SaslAuthenticator.toBson(document);
        }

        private byte[] computeClientFinalMessage(byte[] serverFirst) throws SaslException {
            RawBsonDocument document = new RawBsonDocument(serverFirst);
            String host = document.getString("h").getValue();
            byte[] serverNonce = document.getBinary("s").getData();
            if (serverNonce.length != 64) {
                throw new SaslException(String.format("Server nonce must be %d bytes", 64));
            }
            if (!Arrays.equals(Arrays.copyOf(serverNonce, 32), this.clientNonce)) {
                throw new SaslException(String.format("The first %d bytes of the server nonce must be the client nonce", 32));
            }
            String timestamp = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").withZone(ZoneId.of("UTC")).format(Instant.now());
            AwsCredential awsCredential = this.createAwsCredential();
            String sessionToken = awsCredential.getSessionToken();
            AuthorizationHeader authorizationHeader = AuthorizationHeader.builder().setAccessKeyID(awsCredential.getAccessKeyId()).setSecretKey(awsCredential.getSecretAccessKey()).setSessionToken(sessionToken).setHost(host).setNonce(serverNonce).setTimestamp(timestamp).build();
            BsonDocument ret = new BsonDocument().append("a", new BsonString(authorizationHeader.toString())).append("d", new BsonString(authorizationHeader.getTimestamp()));
            if (sessionToken != null) {
                ret.append("t", new BsonString(sessionToken));
            }
            return SaslAuthenticator.toBson(ret);
        }

        private AwsCredential createAwsCredential() {
            AwsCredential awsCredential;
            MongoCredential credential = this.getCredential();
            if (credential.getUserName() != null) {
                if (credential.getPassword() == null) {
                    throw new MongoClientException("secretAccessKey is required for AWS credential");
                }
                awsCredential = new AwsCredential(Assertions.assertNotNull(credential.getUserName()), new String(Assertions.assertNotNull(credential.getPassword())), credential.getMechanismProperty("AWS_SESSION_TOKEN", null));
            } else if (credential.getMechanismProperty("AWS_CREDENTIAL_PROVIDER", null) != null) {
                Supplier awsCredentialSupplier = Assertions.assertNotNull(credential.getMechanismProperty("AWS_CREDENTIAL_PROVIDER", null));
                awsCredential = (AwsCredential)awsCredentialSupplier.get();
                if (awsCredential == null) {
                    throw new MongoClientException("AWS_CREDENTIAL_PROVIDER_KEY must return an AwsCredential instance");
                }
            } else {
                awsCredential = AwsCredentialHelper.obtainFromEnvironment();
                if (awsCredential == null) {
                    throw new MongoClientException("Unable to obtain AWS credential from the environment");
                }
            }
            return awsCredential;
        }
    }
}

