/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.bulk;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.model.Collation;
import com.dre.brewery.depend.mongodb.internal.bulk.WriteRequest;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.List;

public final class UpdateRequest
extends WriteRequest {
    private final BsonValue update;
    private final WriteRequest.Type updateType;
    private final BsonDocument filter;
    private boolean isMulti;
    private boolean isUpsert = false;
    private Collation collation;
    private List<BsonDocument> arrayFilters;
    @Nullable
    private BsonDocument hint;
    @Nullable
    private String hintString;

    public UpdateRequest(BsonDocument filter, @Nullable BsonValue update, WriteRequest.Type updateType) {
        if (updateType != WriteRequest.Type.UPDATE && updateType != WriteRequest.Type.REPLACE) {
            throw new IllegalArgumentException("Update type must be UPDATE or REPLACE");
        }
        if (update != null && !update.isDocument() && !update.isArray()) {
            throw new IllegalArgumentException("Update operation type must be a document or a pipeline");
        }
        this.filter = Assertions.notNull("filter", filter);
        this.update = Assertions.notNull("update", update);
        this.updateType = updateType;
        this.isMulti = updateType == WriteRequest.Type.UPDATE;
    }

    @Override
    public WriteRequest.Type getType() {
        return this.updateType;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public BsonValue getUpdateValue() {
        return this.update;
    }

    public boolean isMulti() {
        return this.isMulti;
    }

    public UpdateRequest multi(boolean isMulti) {
        if (isMulti && this.updateType == WriteRequest.Type.REPLACE) {
            throw new IllegalArgumentException("Replacements can not be multi");
        }
        this.isMulti = isMulti;
        return this;
    }

    public boolean isUpsert() {
        return this.isUpsert;
    }

    public UpdateRequest upsert(boolean isUpsert) {
        this.isUpsert = isUpsert;
        return this;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    public UpdateRequest collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public UpdateRequest arrayFilters(@Nullable List<BsonDocument> arrayFilters) {
        this.arrayFilters = arrayFilters;
        return this;
    }

    @Nullable
    public List<BsonDocument> getArrayFilters() {
        return this.arrayFilters;
    }

    @Nullable
    public BsonDocument getHint() {
        return this.hint;
    }

    public UpdateRequest hint(@Nullable BsonDocument hint) {
        this.hint = hint;
        return this;
    }

    @Nullable
    public String getHintString() {
        return this.hintString;
    }

    public UpdateRequest hintString(@Nullable String hint) {
        this.hintString = hint;
        return this;
    }
}

