/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal;

import com.dre.brewery.depend.mongodb.MongoClientException;
import com.dre.brewery.depend.mongodb.MongoOperationTimeoutException;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.internal.TimeoutSettings;
import com.dre.brewery.depend.mongodb.internal.time.StartTime;
import com.dre.brewery.depend.mongodb.internal.time.Timeout;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import com.dre.brewery.depend.mongodb.session.ClientSession;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.LongConsumer;

public class TimeoutContext {
    private final boolean isMaintenanceContext;
    private final TimeoutSettings timeoutSettings;
    @Nullable
    private Timeout timeout;
    @Nullable
    private Timeout computedServerSelectionTimeout;
    private long minRoundTripTimeMS = 0L;
    @Nullable
    private MaxTimeSupplier maxTimeSupplier = null;

    public static MongoOperationTimeoutException createMongoRoundTripTimeoutException() {
        return TimeoutContext.createMongoTimeoutException("Remaining timeoutMS is less than or equal to the server's minimum round trip time.");
    }

    public static MongoOperationTimeoutException createMongoTimeoutException(String message) {
        return new MongoOperationTimeoutException(message);
    }

    public static <T> T throwMongoTimeoutException(String message) {
        throw new MongoOperationTimeoutException(message);
    }

    public static MongoOperationTimeoutException createMongoTimeoutException(Throwable cause) {
        return TimeoutContext.createMongoTimeoutException("Operation exceeded the timeout limit: " + cause.getMessage(), cause);
    }

    public static MongoOperationTimeoutException createMongoTimeoutException(String message, Throwable cause) {
        if (cause instanceof MongoOperationTimeoutException) {
            return (MongoOperationTimeoutException)cause;
        }
        return new MongoOperationTimeoutException(message, cause);
    }

    public static TimeoutContext createMaintenanceTimeoutContext(TimeoutSettings timeoutSettings) {
        return new TimeoutContext(true, timeoutSettings, TimeoutContext.startTimeout(timeoutSettings.getTimeoutMS()));
    }

    public static TimeoutContext createTimeoutContext(ClientSession session, TimeoutSettings timeoutSettings) {
        TimeoutContext sessionTimeoutContext = session.getTimeoutContext();
        if (sessionTimeoutContext != null) {
            TimeoutSettings sessionTimeoutSettings = sessionTimeoutContext.timeoutSettings;
            if (timeoutSettings.getGenerationId() > sessionTimeoutSettings.getGenerationId()) {
                throw new MongoClientException("Cannot change the timeoutMS during a transaction.");
            }
            if (sessionTimeoutSettings.getTimeoutMS() == null) {
                if (timeoutSettings.getMaxTimeMS() != 0L) {
                    sessionTimeoutSettings = sessionTimeoutSettings.withMaxTimeMS(timeoutSettings.getMaxTimeMS());
                }
                if (timeoutSettings.getMaxAwaitTimeMS() != 0L) {
                    sessionTimeoutSettings = sessionTimeoutSettings.withMaxAwaitTimeMS(timeoutSettings.getMaxAwaitTimeMS());
                }
                if (timeoutSettings.getMaxCommitTimeMS() != null) {
                    sessionTimeoutSettings = sessionTimeoutSettings.withMaxCommitMS(timeoutSettings.getMaxCommitTimeMS());
                }
                return new TimeoutContext(sessionTimeoutSettings);
            }
            return sessionTimeoutContext;
        }
        return new TimeoutContext(timeoutSettings);
    }

    public TimeoutContext copyTimeoutContext() {
        return new TimeoutContext(this.getTimeoutSettings(), this.getTimeout());
    }

    public TimeoutContext(TimeoutSettings timeoutSettings) {
        this(false, timeoutSettings, TimeoutContext.startTimeout(timeoutSettings.getTimeoutMS()));
    }

    private TimeoutContext(TimeoutSettings timeoutSettings, @Nullable Timeout timeout) {
        this(false, timeoutSettings, timeout);
    }

    private TimeoutContext(boolean isMaintenanceContext, TimeoutSettings timeoutSettings, @Nullable Timeout timeout) {
        this.isMaintenanceContext = isMaintenanceContext;
        this.timeoutSettings = timeoutSettings;
        this.timeout = timeout;
    }

    public boolean hasTimeoutMS() {
        return this.timeoutSettings.getTimeoutMS() != null;
    }

    public void onExpired(Runnable onExpired) {
        Timeout.nullAsInfinite(this.timeout).onExpired(onExpired);
    }

    public TimeoutContext minRoundTripTimeMS(long minRoundTripTimeMS) {
        Assertions.isTrue("'minRoundTripTimeMS' must be a positive number", minRoundTripTimeMS >= 0L);
        this.minRoundTripTimeMS = minRoundTripTimeMS;
        return this;
    }

    @Nullable
    public Timeout timeoutIncludingRoundTrip() {
        return this.timeout == null ? null : this.timeout.shortenBy(this.minRoundTripTimeMS, TimeUnit.MILLISECONDS);
    }

    public long timeoutOrAlternative(long alternativeTimeoutMS) {
        if (this.timeout == null) {
            return alternativeTimeoutMS;
        }
        return this.timeout.call(TimeUnit.MILLISECONDS, () -> 0L, ms -> ms, () -> (Long)TimeoutContext.throwMongoTimeoutException("The operation exceeded the timeout limit."));
    }

    public TimeoutSettings getTimeoutSettings() {
        return this.timeoutSettings;
    }

    public long getMaxAwaitTimeMS() {
        return this.timeoutSettings.getMaxAwaitTimeMS();
    }

    public void runMaxTimeMS(LongConsumer onRemaining) {
        if (this.maxTimeSupplier != null) {
            TimeoutContext.runWithFixedTimeout(this.maxTimeSupplier.get(), onRemaining);
            return;
        }
        if (this.timeout == null) {
            TimeoutContext.runWithFixedTimeout(this.timeoutSettings.getMaxTimeMS(), onRemaining);
            return;
        }
        this.timeout.shortenBy(this.minRoundTripTimeMS, TimeUnit.MILLISECONDS).run(TimeUnit.MILLISECONDS, () -> {}, onRemaining, () -> {
            throw TimeoutContext.createMongoRoundTripTimeoutException();
        });
    }

    private static void runWithFixedTimeout(long ms, LongConsumer onRemaining) {
        if (ms != 0L) {
            onRemaining.accept(ms);
        }
    }

    public void resetToDefaultMaxTime() {
        this.maxTimeSupplier = null;
    }

    public void setMaxTimeOverride(long maxTimeMS) {
        this.maxTimeSupplier = () -> maxTimeMS;
    }

    public void disableMaxTimeOverride() {
        this.maxTimeSupplier = () -> 0L;
    }

    public void setMaxTimeOverrideToMaxCommitTime() {
        this.maxTimeSupplier = () -> this.getMaxCommitTimeMS();
    }

    public long getMaxCommitTimeMS() {
        Long maxCommitTimeMS = this.timeoutSettings.getMaxCommitTimeMS();
        return this.timeoutOrAlternative(maxCommitTimeMS != null ? maxCommitTimeMS : 0L);
    }

    public long getReadTimeoutMS() {
        return this.timeoutOrAlternative(this.timeoutSettings.getReadTimeoutMS());
    }

    public long getWriteTimeoutMS() {
        return this.timeoutOrAlternative(0L);
    }

    public int getConnectTimeoutMs() {
        long connectTimeoutMS = this.getTimeoutSettings().getConnectTimeoutMS();
        return Math.toIntExact(Timeout.nullAsInfinite(this.timeout).call(TimeUnit.MILLISECONDS, () -> connectTimeoutMS, ms -> connectTimeoutMS == 0L ? ms : Math.min(ms, connectTimeoutMS), () -> (Long)TimeoutContext.throwMongoTimeoutException("The operation exceeded the timeout limit.")));
    }

    public void resetTimeoutIfPresent() {
        if (this.hasTimeoutMS()) {
            this.timeout = TimeoutContext.startTimeout(this.timeoutSettings.getTimeoutMS());
        }
    }

    public void resetMaintenanceTimeout() {
        if (!this.isMaintenanceContext) {
            return;
        }
        this.timeout = Timeout.nullAsInfinite(this.timeout).call(TimeUnit.NANOSECONDS, () -> this.timeout, ms -> TimeoutContext.startTimeout(this.timeoutSettings.getTimeoutMS()), () -> TimeoutContext.startTimeout(this.timeoutSettings.getTimeoutMS()));
    }

    public TimeoutContext withAdditionalReadTimeout(int additionalReadTimeout) {
        Assertions.assertNull(this.timeout);
        if (this.timeoutSettings.getReadTimeoutMS() == 0L) {
            return this;
        }
        long newReadTimeout = this.getReadTimeoutMS() + (long)additionalReadTimeout;
        return new TimeoutContext(this.timeoutSettings.withReadTimeoutMS(newReadTimeout > 0L ? newReadTimeout : Long.MAX_VALUE));
    }

    public String toString() {
        return "TimeoutContext{isMaintenanceContext=" + this.isMaintenanceContext + ", timeoutSettings=" + this.timeoutSettings + ", timeout=" + this.timeout + ", minRoundTripTimeMS=" + this.minRoundTripTimeMS + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeoutContext that = (TimeoutContext)o;
        return this.isMaintenanceContext == that.isMaintenanceContext && this.minRoundTripTimeMS == that.minRoundTripTimeMS && Objects.equals(this.timeoutSettings, that.timeoutSettings) && Objects.equals(this.timeout, that.timeout);
    }

    public int hashCode() {
        return Objects.hash(this.isMaintenanceContext, this.timeoutSettings, this.timeout, this.minRoundTripTimeMS);
    }

    @Nullable
    public static Timeout startTimeout(@Nullable Long timeoutMS) {
        if (timeoutMS != null) {
            return Timeout.expiresIn(timeoutMS, TimeUnit.MILLISECONDS, Timeout.ZeroSemantics.ZERO_DURATION_MEANS_INFINITE);
        }
        return null;
    }

    public Timeout computeServerSelectionTimeout() {
        Timeout serverSelectionTimeout = StartTime.now().timeoutAfterOrInfiniteIfNegative(this.getTimeoutSettings().getServerSelectionTimeoutMS(), TimeUnit.MILLISECONDS);
        if (this.isMaintenanceContext || !this.hasTimeoutMS()) {
            return serverSelectionTimeout;
        }
        if (this.timeout != null && Timeout.earliest(serverSelectionTimeout, this.timeout) == this.timeout) {
            return this.timeout;
        }
        this.computedServerSelectionTimeout = serverSelectionTimeout;
        return this.computedServerSelectionTimeout;
    }

    public TimeoutContext withComputedServerSelectionTimeoutContext() {
        if (this.hasTimeoutMS() && this.computedServerSelectionTimeout != null) {
            return new TimeoutContext(false, this.timeoutSettings, this.computedServerSelectionTimeout);
        }
        return this;
    }

    public Timeout startWaitQueueTimeout(StartTime checkoutStart) {
        long ms = this.getTimeoutSettings().getMaxWaitTimeMS();
        return checkoutStart.timeoutAfterOrInfiniteIfNegative(ms, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public Timeout getTimeout() {
        return this.timeout;
    }

    public static interface MaxTimeSupplier {
        public long get();
    }
}

