/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal;

import com.dre.brewery.depend.mongodb.annotations.ThreadSafe;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.time.Duration;
import java.util.Optional;

@ThreadSafe
public final class ExpirableValue<T> {
    private final T value;
    private final long deadline;

    public static <T> ExpirableValue<T> expired() {
        return new ExpirableValue<Object>(null, Duration.ZERO, System.nanoTime());
    }

    public static <T> ExpirableValue<T> expirable(T value, Duration lifetime) {
        return ExpirableValue.expirable(value, lifetime, System.nanoTime());
    }

    public static <T> ExpirableValue<T> expirable(T value, Duration lifetime, long startNanoTime) {
        return new ExpirableValue<T>(Assertions.assertNotNull(value), Assertions.assertNotNull(lifetime), startNanoTime);
    }

    private ExpirableValue(@Nullable T value, Duration lifetime, long currentNanoTime) {
        this.value = value;
        this.deadline = currentNanoTime + lifetime.toNanos();
    }

    public Optional<T> getValue() {
        return this.getValue(System.nanoTime());
    }

    Optional<T> getValue(long currentNanoTime) {
        if (currentNanoTime - this.deadline >= 0L) {
            return Optional.empty();
        }
        return Optional.of(this.value);
    }
}

