/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.connection;

import com.dre.brewery.depend.mongodb.ConnectionString;
import com.dre.brewery.depend.mongodb.annotations.Immutable;
import com.dre.brewery.depend.mongodb.annotations.NotThreadSafe;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ServerMonitoringMode;
import com.dre.brewery.depend.mongodb.event.ServerListener;
import com.dre.brewery.depend.mongodb.event.ServerMonitorListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Immutable
public class ServerSettings {
    private final long heartbeatFrequencyMS;
    private final long minHeartbeatFrequencyMS;
    private final ServerMonitoringMode serverMonitoringMode;
    private final List<ServerListener> serverListeners;
    private final List<ServerMonitorListener> serverMonitorListeners;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServerSettings serverSettings) {
        return ServerSettings.builder().applySettings(serverSettings);
    }

    public long getHeartbeatFrequency(TimeUnit timeUnit) {
        return timeUnit.convert(this.heartbeatFrequencyMS, TimeUnit.MILLISECONDS);
    }

    public long getMinHeartbeatFrequency(TimeUnit timeUnit) {
        return timeUnit.convert(this.minHeartbeatFrequencyMS, TimeUnit.MILLISECONDS);
    }

    public ServerMonitoringMode getServerMonitoringMode() {
        return this.serverMonitoringMode;
    }

    public List<ServerListener> getServerListeners() {
        return this.serverListeners;
    }

    public List<ServerMonitorListener> getServerMonitorListeners() {
        return this.serverMonitorListeners;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerSettings that = (ServerSettings)o;
        return this.heartbeatFrequencyMS == that.heartbeatFrequencyMS && this.minHeartbeatFrequencyMS == that.minHeartbeatFrequencyMS && this.serverMonitoringMode == that.serverMonitoringMode && Objects.equals(this.serverListeners, that.serverListeners) && Objects.equals(this.serverMonitorListeners, that.serverMonitorListeners);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.heartbeatFrequencyMS, this.minHeartbeatFrequencyMS, this.serverMonitoringMode, this.serverListeners, this.serverMonitorListeners});
    }

    public String toString() {
        return "ServerSettings{heartbeatFrequencyMS=" + this.heartbeatFrequencyMS + ", minHeartbeatFrequencyMS=" + this.minHeartbeatFrequencyMS + ", serverMonitoringMode=" + (Object)((Object)this.serverMonitoringMode) + ", serverListeners='" + this.serverListeners + '\'' + ", serverMonitorListeners='" + this.serverMonitorListeners + '\'' + '}';
    }

    ServerSettings(Builder builder) {
        this.heartbeatFrequencyMS = builder.heartbeatFrequencyMS;
        this.minHeartbeatFrequencyMS = builder.minHeartbeatFrequencyMS;
        this.serverMonitoringMode = builder.serverMonitoringMode;
        this.serverListeners = Collections.unmodifiableList(builder.serverListeners);
        this.serverMonitorListeners = Collections.unmodifiableList(builder.serverMonitorListeners);
    }

    @NotThreadSafe
    public static final class Builder {
        private long heartbeatFrequencyMS = 10000L;
        private long minHeartbeatFrequencyMS = 500L;
        private ServerMonitoringMode serverMonitoringMode = ServerMonitoringMode.AUTO;
        private List<ServerListener> serverListeners = new ArrayList<ServerListener>();
        private List<ServerMonitorListener> serverMonitorListeners = new ArrayList<ServerMonitorListener>();

        private Builder() {
        }

        public Builder applySettings(ServerSettings serverSettings) {
            Assertions.notNull("serverSettings", serverSettings);
            this.heartbeatFrequencyMS = serverSettings.heartbeatFrequencyMS;
            this.minHeartbeatFrequencyMS = serverSettings.minHeartbeatFrequencyMS;
            this.serverMonitoringMode = serverSettings.serverMonitoringMode;
            this.serverListeners = new ArrayList<ServerListener>(serverSettings.serverListeners);
            this.serverMonitorListeners = new ArrayList<ServerMonitorListener>(serverSettings.serverMonitorListeners);
            return this;
        }

        public Builder heartbeatFrequency(long heartbeatFrequency, TimeUnit timeUnit) {
            this.heartbeatFrequencyMS = TimeUnit.MILLISECONDS.convert(heartbeatFrequency, timeUnit);
            return this;
        }

        public Builder minHeartbeatFrequency(long minHeartbeatFrequency, TimeUnit timeUnit) {
            this.minHeartbeatFrequencyMS = TimeUnit.MILLISECONDS.convert(minHeartbeatFrequency, timeUnit);
            return this;
        }

        public Builder serverMonitoringMode(ServerMonitoringMode serverMonitoringMode) {
            this.serverMonitoringMode = Assertions.notNull("serverMonitoringMode", serverMonitoringMode);
            return this;
        }

        public Builder addServerListener(ServerListener serverListener) {
            Assertions.notNull("serverListener", serverListener);
            this.serverListeners.add(serverListener);
            return this;
        }

        public Builder serverListenerList(List<ServerListener> serverListeners) {
            Assertions.notNull("serverListeners", serverListeners);
            this.serverListeners = new ArrayList<ServerListener>(serverListeners);
            return this;
        }

        public Builder addServerMonitorListener(ServerMonitorListener serverMonitorListener) {
            Assertions.notNull("serverMonitorListener", serverMonitorListener);
            this.serverMonitorListeners.add(serverMonitorListener);
            return this;
        }

        public Builder serverMonitorListenerList(List<ServerMonitorListener> serverMonitorListeners) {
            Assertions.notNull("serverMonitorListeners", serverMonitorListeners);
            this.serverMonitorListeners = new ArrayList<ServerMonitorListener>(serverMonitorListeners);
            return this;
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            ServerMonitoringMode serverMonitoringMode;
            Integer heartbeatFrequency = connectionString.getHeartbeatFrequency();
            if (heartbeatFrequency != null) {
                this.heartbeatFrequencyMS = heartbeatFrequency.intValue();
            }
            if ((serverMonitoringMode = connectionString.getServerMonitoringMode()) != null) {
                this.serverMonitoringMode = serverMonitoringMode;
            }
            return this;
        }

        public ServerSettings build() {
            return new ServerSettings(this);
        }
    }
}

