/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.connection;

import com.dre.brewery.depend.mongodb.annotations.Immutable;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ServerId;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

@Immutable
public final class ConnectionId {
    private static final AtomicLong INCREMENTING_ID = new AtomicLong();
    private final ServerId serverId;
    private final long localValue;
    @Nullable
    private final Long serverValue;
    private final String stringValue;

    public ConnectionId(ServerId serverId) {
        this(serverId, INCREMENTING_ID.incrementAndGet(), null);
    }

    public ConnectionId(ServerId serverId, long localValue, @Nullable Long serverValue) {
        this.serverId = Assertions.notNull("serverId", serverId);
        this.localValue = localValue;
        this.serverValue = serverValue;
        this.stringValue = serverValue == null ? String.format("connectionId{localValue:%s}", localValue) : String.format("connectionId{localValue:%s, serverValue:%s}", localValue, serverValue);
    }

    public ConnectionId withServerValue(long serverValue) {
        Assertions.isTrue("server value is null", this.serverValue == null);
        return new ConnectionId(this.serverId, this.localValue, serverValue);
    }

    public ServerId getServerId() {
        return this.serverId;
    }

    public long getLocalValue() {
        return this.localValue;
    }

    @Nullable
    public Long getServerValue() {
        return this.serverValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionId that = (ConnectionId)o;
        if (this.localValue != that.localValue) {
            return false;
        }
        if (!this.serverId.equals(that.serverId)) {
            return false;
        }
        return Objects.equals(this.serverValue, that.serverValue);
    }

    public int hashCode() {
        return Objects.hash(this.serverId, this.localValue, this.serverValue);
    }

    public String toString() {
        return this.stringValue;
    }
}

