/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.connection;

import com.dre.brewery.depend.mongodb.ConnectionString;
import com.dre.brewery.depend.mongodb.ServerAddress;
import com.dre.brewery.depend.mongodb.annotations.Immutable;
import com.dre.brewery.depend.mongodb.annotations.NotThreadSafe;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ClusterConnectionMode;
import com.dre.brewery.depend.mongodb.connection.ClusterType;
import com.dre.brewery.depend.mongodb.event.ClusterListener;
import com.dre.brewery.depend.mongodb.internal.connection.ServerAddressHelper;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import com.dre.brewery.depend.mongodb.selector.ServerSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Immutable
public final class ClusterSettings {
    private final String srvHost;
    private final Integer srvMaxHosts;
    private final String srvServiceName;
    private final List<ServerAddress> hosts;
    private final ClusterConnectionMode mode;
    private final ClusterType requiredClusterType;
    private final String requiredReplicaSetName;
    private final ServerSelector serverSelector;
    private final long localThresholdMS;
    private final long serverSelectionTimeoutMS;
    private final List<ClusterListener> clusterListeners;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterSettings clusterSettings) {
        return ClusterSettings.builder().applySettings(clusterSettings);
    }

    @Nullable
    public String getSrvHost() {
        return this.srvHost;
    }

    @Nullable
    public Integer getSrvMaxHosts() {
        return this.srvMaxHosts;
    }

    public String getSrvServiceName() {
        return this.srvServiceName;
    }

    public List<ServerAddress> getHosts() {
        return this.hosts;
    }

    public ClusterConnectionMode getMode() {
        return this.mode;
    }

    public ClusterType getRequiredClusterType() {
        return this.requiredClusterType;
    }

    @Nullable
    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    @Nullable
    public ServerSelector getServerSelector() {
        return this.serverSelector;
    }

    public long getServerSelectionTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.serverSelectionTimeoutMS, TimeUnit.MILLISECONDS);
    }

    public long getLocalThreshold(TimeUnit timeUnit) {
        return timeUnit.convert(this.localThresholdMS, TimeUnit.MILLISECONDS);
    }

    public List<ClusterListener> getClusterListeners() {
        return this.clusterListeners;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterSettings that = (ClusterSettings)o;
        return this.localThresholdMS == that.localThresholdMS && this.serverSelectionTimeoutMS == that.serverSelectionTimeoutMS && Objects.equals(this.srvHost, that.srvHost) && Objects.equals(this.srvMaxHosts, that.srvMaxHosts) && this.srvServiceName.equals(that.srvServiceName) && this.hosts.equals(that.hosts) && this.mode == that.mode && this.requiredClusterType == that.requiredClusterType && Objects.equals(this.requiredReplicaSetName, that.requiredReplicaSetName) && Objects.equals(this.serverSelector, that.serverSelector) && this.clusterListeners.equals(that.clusterListeners);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.srvHost, this.srvMaxHosts, this.srvServiceName, this.hosts, this.mode, this.requiredClusterType, this.requiredReplicaSetName, this.serverSelector, this.localThresholdMS, this.serverSelectionTimeoutMS, this.clusterListeners});
    }

    public String toString() {
        return "{" + (this.hosts.isEmpty() ? "" : "hosts=" + this.hosts) + (this.srvHost == null ? "" : ", srvHost=" + this.srvHost) + (this.srvServiceName == null ? "" : ", srvServiceName=" + this.srvServiceName) + (this.srvMaxHosts == null ? "" : ", srvMaxHosts=" + this.srvMaxHosts) + ", mode=" + (Object)((Object)this.mode) + ", requiredClusterType=" + (Object)((Object)this.requiredClusterType) + ", requiredReplicaSetName='" + this.requiredReplicaSetName + '\'' + ", serverSelector='" + this.serverSelector + '\'' + ", clusterListeners='" + this.clusterListeners + '\'' + ", serverSelectionTimeout='" + this.serverSelectionTimeoutMS + " ms" + '\'' + ", localThreshold='" + this.localThresholdMS + " ms" + '\'' + '}';
    }

    public String getShortDescription() {
        return "{" + (this.hosts.isEmpty() ? "" : "hosts=" + this.hosts) + (this.srvHost == null ? "" : ", srvHost=" + this.srvHost) + ", mode=" + (Object)((Object)this.mode) + ", requiredClusterType=" + (Object)((Object)this.requiredClusterType) + ", serverSelectionTimeout='" + this.serverSelectionTimeoutMS + " ms" + '\'' + (this.requiredReplicaSetName == null ? "" : ", requiredReplicaSetName='" + this.requiredReplicaSetName + '\'') + '}';
    }

    private ClusterSettings(Builder builder) {
        if (builder.srvHost != null && builder.srvHost.contains(":")) {
            throw new IllegalArgumentException("The srvHost can not contain a host name that specifies a port");
        }
        if (builder.hosts.size() > 1 && builder.requiredClusterType == ClusterType.STANDALONE) {
            throw new IllegalArgumentException("Multiple hosts cannot be specified when using ClusterType.STANDALONE.");
        }
        if (builder.requiredReplicaSetName != null) {
            if (builder.requiredClusterType == ClusterType.UNKNOWN) {
                builder.requiredClusterType = ClusterType.REPLICA_SET;
            } else if (builder.requiredClusterType != ClusterType.REPLICA_SET) {
                throw new IllegalArgumentException("When specifying a replica set name, only ClusterType.UNKNOWN and ClusterType.REPLICA_SET are valid.");
            }
        }
        this.srvHost = builder.srvHost;
        this.srvMaxHosts = builder.srvMaxHosts;
        this.srvServiceName = builder.srvServiceName;
        this.hosts = builder.hosts;
        this.requiredReplicaSetName = builder.requiredReplicaSetName;
        if (builder.mode != null) {
            switch (builder.mode) {
                case SINGLE: {
                    if (this.srvHost != null) {
                        throw new IllegalArgumentException("An SRV host name was provided but the connection mode is not MULTIPLE");
                    }
                    if (builder.hosts.size() <= 1) break;
                    throw new IllegalArgumentException("Can not directly connect to more than one server");
                }
                case LOAD_BALANCED: {
                    if (builder.srvHost != null || builder.hosts.size() == 1) break;
                    throw new IllegalArgumentException("Multiple hosts cannot be specified when in load balancing mode");
                }
            }
            this.mode = builder.mode;
        } else {
            this.mode = this.srvHost != null ? ClusterConnectionMode.MULTIPLE : (this.hosts.size() == 1 && this.requiredReplicaSetName == null ? ClusterConnectionMode.SINGLE : ClusterConnectionMode.MULTIPLE);
        }
        this.requiredClusterType = builder.requiredClusterType;
        this.localThresholdMS = builder.localThresholdMS;
        this.serverSelector = builder.serverSelector;
        this.serverSelectionTimeoutMS = builder.serverSelectionTimeoutMS;
        this.clusterListeners = Collections.unmodifiableList(builder.clusterListeners);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final List<ServerAddress> DEFAULT_HOSTS = Collections.singletonList(new ServerAddress());
        private String srvHost;
        private Integer srvMaxHosts;
        private String srvServiceName = "mongodb";
        private List<ServerAddress> hosts = DEFAULT_HOSTS;
        private ClusterConnectionMode mode;
        private ClusterType requiredClusterType = ClusterType.UNKNOWN;
        private String requiredReplicaSetName;
        private ServerSelector serverSelector;
        private long serverSelectionTimeoutMS = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
        private long localThresholdMS = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MILLISECONDS);
        private List<ClusterListener> clusterListeners = new ArrayList<ClusterListener>();

        private Builder() {
        }

        public Builder applySettings(ClusterSettings clusterSettings) {
            Assertions.notNull("clusterSettings", clusterSettings);
            this.srvHost = clusterSettings.srvHost;
            this.srvServiceName = clusterSettings.srvServiceName;
            this.srvMaxHosts = clusterSettings.srvMaxHosts;
            this.hosts = clusterSettings.hosts;
            this.mode = clusterSettings.mode;
            this.requiredReplicaSetName = clusterSettings.requiredReplicaSetName;
            this.requiredClusterType = clusterSettings.requiredClusterType;
            this.localThresholdMS = clusterSettings.localThresholdMS;
            this.serverSelectionTimeoutMS = clusterSettings.serverSelectionTimeoutMS;
            this.clusterListeners = new ArrayList<ClusterListener>(clusterSettings.clusterListeners);
            this.serverSelector = clusterSettings.serverSelector;
            return this;
        }

        public Builder srvHost(String srvHost) {
            if (this.hosts != DEFAULT_HOSTS) {
                throw new IllegalArgumentException("Can not set both hosts and srvHost");
            }
            this.srvHost = srvHost;
            return this;
        }

        public Builder srvMaxHosts(Integer srvMaxHosts) {
            this.srvMaxHosts = srvMaxHosts;
            return this;
        }

        public Builder srvServiceName(String srvServiceName) {
            this.srvServiceName = Assertions.notNull("srvServiceName", srvServiceName);
            return this;
        }

        public Builder hosts(List<ServerAddress> hosts) {
            Assertions.notNull("hosts", hosts);
            if (hosts.isEmpty()) {
                throw new IllegalArgumentException("hosts list may not be empty");
            }
            if (this.srvHost != null) {
                throw new IllegalArgumentException("srvHost must be null");
            }
            LinkedHashSet<ServerAddress> hostsSet = new LinkedHashSet<ServerAddress>(hosts.size());
            for (ServerAddress serverAddress : hosts) {
                Assertions.notNull("serverAddress", serverAddress);
                hostsSet.add(ServerAddressHelper.createServerAddress(serverAddress.getHost(), serverAddress.getPort()));
            }
            this.hosts = Collections.unmodifiableList(new ArrayList(hostsSet));
            return this;
        }

        public Builder mode(ClusterConnectionMode mode) {
            this.mode = Assertions.notNull("mode", mode);
            return this;
        }

        public Builder requiredReplicaSetName(@Nullable String requiredReplicaSetName) {
            this.requiredReplicaSetName = requiredReplicaSetName;
            return this;
        }

        public Builder requiredClusterType(ClusterType requiredClusterType) {
            this.requiredClusterType = Assertions.notNull("requiredClusterType", requiredClusterType);
            return this;
        }

        public Builder localThreshold(long localThreshold, TimeUnit timeUnit) {
            Assertions.isTrueArgument("localThreshold must be >= 0", localThreshold >= 0L);
            this.localThresholdMS = TimeUnit.MILLISECONDS.convert(localThreshold, timeUnit);
            return this;
        }

        public Builder serverSelector(ServerSelector serverSelector) {
            this.serverSelector = serverSelector;
            return this;
        }

        public Builder serverSelectionTimeout(long serverSelectionTimeout, TimeUnit timeUnit) {
            this.serverSelectionTimeoutMS = TimeUnit.MILLISECONDS.convert(serverSelectionTimeout, timeUnit);
            return this;
        }

        public Builder addClusterListener(ClusterListener clusterListener) {
            Assertions.notNull("clusterListener", clusterListener);
            this.clusterListeners.add(clusterListener);
            return this;
        }

        public Builder clusterListenerList(List<ClusterListener> clusterListeners) {
            Assertions.notNull("clusterListeners", clusterListeners);
            this.clusterListeners = new ArrayList<ClusterListener>(clusterListeners);
            return this;
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            Integer localThreshold;
            Boolean directConnection = connectionString.isDirectConnection();
            Boolean loadBalanced = connectionString.isLoadBalanced();
            if (loadBalanced != null && loadBalanced.booleanValue()) {
                this.mode(ClusterConnectionMode.LOAD_BALANCED);
                if (connectionString.isSrvProtocol()) {
                    this.srvHost(connectionString.getHosts().get(0));
                } else {
                    this.hosts(Collections.singletonList(ServerAddressHelper.createServerAddress(connectionString.getHosts().get(0))));
                }
            } else if (connectionString.isSrvProtocol()) {
                String srvServiceName;
                this.mode(ClusterConnectionMode.MULTIPLE);
                this.srvHost(connectionString.getHosts().get(0));
                Integer srvMaxHosts = connectionString.getSrvMaxHosts();
                if (srvMaxHosts != null) {
                    this.srvMaxHosts(srvMaxHosts);
                }
                if ((srvServiceName = connectionString.getSrvServiceName()) != null) {
                    this.srvServiceName(srvServiceName);
                }
            } else if (directConnection != null) {
                this.mode(directConnection != false ? ClusterConnectionMode.SINGLE : ClusterConnectionMode.MULTIPLE);
                List<String> hosts = directConnection != false ? Collections.singletonList(connectionString.getHosts().get(0)) : connectionString.getHosts();
                this.hosts(hosts.stream().map(ServerAddressHelper::createServerAddress).collect(Collectors.toList()));
            } else {
                this.mode = null;
                List<ServerAddress> seedList = connectionString.getHosts().stream().map(ServerAddressHelper::createServerAddress).collect(Collectors.toList());
                this.hosts(seedList);
            }
            this.requiredReplicaSetName(connectionString.getRequiredReplicaSetName());
            Integer serverSelectionTimeout = connectionString.getServerSelectionTimeout();
            if (serverSelectionTimeout != null) {
                this.serverSelectionTimeout(serverSelectionTimeout.intValue(), TimeUnit.MILLISECONDS);
            }
            if ((localThreshold = connectionString.getLocalThreshold()) != null) {
                this.localThreshold(localThreshold.intValue(), TimeUnit.MILLISECONDS);
            }
            return this;
        }

        public ClusterSettings build() {
            return new ClusterSettings(this);
        }
    }
}

