/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.client.model.search;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonDouble;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.bson.Document;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistry;
import com.dre.brewery.depend.bson.conversions.Bson;
import com.dre.brewery.depend.mongodb.annotations.Beta;
import com.dre.brewery.depend.mongodb.annotations.Reason;
import com.dre.brewery.depend.mongodb.annotations.Sealed;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.model.search.AddSearchScoreExpression;
import com.dre.brewery.depend.mongodb.client.model.search.ConstantSearchScoreExpression;
import com.dre.brewery.depend.mongodb.client.model.search.FieldSearchPath;
import com.dre.brewery.depend.mongodb.client.model.search.GaussSearchScoreExpression;
import com.dre.brewery.depend.mongodb.client.model.search.Log1pSearchScoreExpression;
import com.dre.brewery.depend.mongodb.client.model.search.LogSearchScoreExpression;
import com.dre.brewery.depend.mongodb.client.model.search.MultiplySearchScoreExpression;
import com.dre.brewery.depend.mongodb.client.model.search.PathSearchScoreExpression;
import com.dre.brewery.depend.mongodb.client.model.search.RelevanceSearchScoreExpression;
import com.dre.brewery.depend.mongodb.client.model.search.SearchConstructibleBson;
import com.dre.brewery.depend.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.dre.brewery.depend.mongodb.internal.client.model.Util;

@Sealed
@Beta(value={Reason.CLIENT})
public interface SearchScoreExpression
extends Bson {
    public static RelevanceSearchScoreExpression relevanceExpression() {
        return new SearchConstructibleBson(new BsonDocument("score", new BsonString("relevance")));
    }

    public static PathSearchScoreExpression pathExpression(FieldSearchPath path) {
        return new SearchConstructibleBsonElement("path", (Bson)new Document("value", Assertions.notNull("path", path).toValue()));
    }

    public static ConstantSearchScoreExpression constantExpression(float value) {
        return new SearchConstructibleBson(new BsonDocument("constant", new BsonDouble(value)));
    }

    public static GaussSearchScoreExpression gaussExpression(final double origin, final PathSearchScoreExpression path, final double scale) {
        Assertions.notNull("path", path);
        Bson value = new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                BsonDocument pathDoc = path.toBsonDocument(documentClass, codecRegistry);
                Assertions.assertTrue(pathDoc.size() == 1);
                return new BsonDocument("origin", new BsonDouble(origin)).append("path", pathDoc.values().iterator().next()).append("scale", new BsonDouble(scale));
            }

            public String toString() {
                return new Document("origin", origin).append("path", path).append("scale", scale).toString();
            }
        };
        return new SearchConstructibleBsonElement("gauss", value);
    }

    public static LogSearchScoreExpression logExpression(SearchScoreExpression expression) {
        return new SearchConstructibleBson(new Document("log", Assertions.notNull("expression", expression)));
    }

    public static Log1pSearchScoreExpression log1pExpression(SearchScoreExpression expression) {
        return new SearchConstructibleBson(new Document("log1p", Assertions.notNull("expression", expression)));
    }

    public static AddSearchScoreExpression addExpression(Iterable<? extends SearchScoreExpression> expressions) {
        Assertions.notNull("expressions", expressions);
        Assertions.isTrueArgument("expressions must contain at least 2 elements", Util.sizeAtLeast(expressions, 2));
        return new SearchConstructibleBson(new Document("add", expressions));
    }

    public static MultiplySearchScoreExpression multiplyExpression(Iterable<? extends SearchScoreExpression> expressions) {
        Assertions.notNull("expressions", expressions);
        Assertions.isTrueArgument("expressions must contain at least 2 elements", Util.sizeAtLeast(expressions, 2));
        return new SearchConstructibleBson(new Document("multiply", expressions));
    }

    public static SearchScoreExpression of(Bson expression) {
        return new SearchConstructibleBson(Assertions.notNull("expression", expression));
    }
}

