/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.client.model.search;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.conversions.Bson;
import com.dre.brewery.depend.mongodb.annotations.Beta;
import com.dre.brewery.depend.mongodb.annotations.Reason;
import com.dre.brewery.depend.mongodb.annotations.Sealed;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.model.search.SearchConstructibleBson;
import com.dre.brewery.depend.mongodb.client.model.search.SearchPath;
import com.dre.brewery.depend.mongodb.internal.Iterables;
import com.dre.brewery.depend.mongodb.internal.client.model.Util;
import java.util.Iterator;

@Sealed
@Beta(value={Reason.CLIENT})
public interface SearchHighlight
extends Bson {
    public SearchHighlight maxCharsToExamine(int var1);

    public SearchHighlight maxNumPassages(int var1);

    public static SearchHighlight paths(SearchPath path, SearchPath ... paths) {
        return SearchHighlight.paths(Iterables.concat(Assertions.notNull("path", path), paths));
    }

    public static SearchHighlight paths(Iterable<? extends SearchPath> paths) {
        Iterator<? extends SearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new SearchConstructibleBson(new BsonDocument("path", Util.combineToBsonValue(pathIterator, false)));
    }

    public static SearchHighlight of(Bson highlight) {
        return new SearchConstructibleBson(Assertions.notNull("highlight", highlight));
    }
}

