/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.client.model.geojson.codecs;

import com.dre.brewery.depend.bson.BsonReader;
import com.dre.brewery.depend.bson.BsonWriter;
import com.dre.brewery.depend.bson.codecs.Codec;
import com.dre.brewery.depend.bson.codecs.DecoderContext;
import com.dre.brewery.depend.bson.codecs.EncoderContext;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistry;
import com.dre.brewery.depend.mongodb.client.model.geojson.Geometry;
import com.dre.brewery.depend.mongodb.client.model.geojson.codecs.GeometryDecoderHelper;
import com.dre.brewery.depend.mongodb.client.model.geojson.codecs.GeometryEncoderHelper;

abstract class AbstractGeometryCodec<T extends Geometry>
implements Codec<T> {
    private final CodecRegistry registry;
    private final Class<T> encoderClass;

    AbstractGeometryCodec(CodecRegistry registry, Class<T> encoderClass) {
        this.registry = registry;
        this.encoderClass = encoderClass;
    }

    @Override
    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        GeometryEncoderHelper.encodeGeometry(writer, value, encoderContext, this.registry);
    }

    @Override
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return GeometryDecoderHelper.decodeGeometry(reader, this.getEncoderClass());
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.encoderClass;
    }
}

