/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.client.model;

import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public class EstimatedDocumentCountOptions {
    private long maxTimeMS;
    private BsonValue comment;

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public EstimatedDocumentCountOptions maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public EstimatedDocumentCountOptions comment(@Nullable String comment) {
        this.comment = comment == null ? null : new BsonString(comment);
        return this;
    }

    public EstimatedDocumentCountOptions comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    public String toString() {
        return "EstimatedCountOptions{, maxTimeMS=" + this.maxTimeMS + ", comment=" + this.comment + '}';
    }
}

