/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.client.internal;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistry;
import com.dre.brewery.depend.bson.conversions.Bson;
import com.dre.brewery.depend.mongodb.ReadConcern;
import com.dre.brewery.depend.mongodb.ReadPreference;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.ClientSession;
import com.dre.brewery.depend.mongodb.client.ListCollectionsIterable;
import com.dre.brewery.depend.mongodb.client.cursor.TimeoutMode;
import com.dre.brewery.depend.mongodb.client.internal.MongoIterableImpl;
import com.dre.brewery.depend.mongodb.client.internal.OperationExecutor;
import com.dre.brewery.depend.mongodb.internal.TimeoutSettings;
import com.dre.brewery.depend.mongodb.internal.operation.BatchCursor;
import com.dre.brewery.depend.mongodb.internal.operation.ReadOperation;
import com.dre.brewery.depend.mongodb.internal.operation.SyncOperations;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

class ListCollectionsIterableImpl<TResult>
extends MongoIterableImpl<TResult>
implements ListCollectionsIterable<TResult> {
    private final SyncOperations<BsonDocument> operations;
    private final String databaseName;
    private final Class<TResult> resultClass;
    private Bson filter;
    private final boolean collectionNamesOnly;
    private boolean authorizedCollections;
    private long maxTimeMS;
    private BsonValue comment;

    ListCollectionsIterableImpl(@Nullable ClientSession clientSession, String databaseName, boolean collectionNamesOnly, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor, boolean retryReads, TimeoutSettings timeoutSettings) {
        super(clientSession, executor, ReadConcern.DEFAULT, readPreference, retryReads, timeoutSettings);
        this.collectionNamesOnly = collectionNamesOnly;
        this.operations = new SyncOperations<BsonDocument>(BsonDocument.class, readPreference, codecRegistry, retryReads, timeoutSettings);
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.resultClass = Assertions.notNull("resultClass", resultClass);
    }

    @Override
    public ListCollectionsIterable<TResult> filter(@Nullable Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public ListCollectionsIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListCollectionsIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public ListCollectionsIterable<TResult> timeoutMode(TimeoutMode timeoutMode) {
        super.timeoutMode(timeoutMode);
        return this;
    }

    @Override
    public ListCollectionsIterable<TResult> comment(@Nullable String comment) {
        this.comment = comment != null ? new BsonString(comment) : null;
        return this;
    }

    @Override
    public ListCollectionsIterable<TResult> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    ListCollectionsIterableImpl<TResult> authorizedCollections(boolean authorizedCollections) {
        this.authorizedCollections = authorizedCollections;
        return this;
    }

    @Override
    public ReadOperation<BatchCursor<TResult>> asReadOperation() {
        return this.operations.listCollections(this.databaseName, this.resultClass, this.filter, this.collectionNamesOnly, this.authorizedCollections, this.getBatchSize(), this.comment, this.getTimeoutMode());
    }

    @Override
    protected OperationExecutor getExecutor() {
        return this.getExecutor(this.operations.createTimeoutSettings(this.maxTimeMS));
    }
}

