/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.client.internal;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.mongodb.MongoNamespace;
import com.dre.brewery.depend.mongodb.ReadConcern;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.MongoClient;
import com.dre.brewery.depend.mongodb.client.MongoCollection;
import com.dre.brewery.depend.mongodb.client.internal.TimeoutHelper;
import com.dre.brewery.depend.mongodb.internal.time.Timeout;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;

class KeyRetriever {
    private static final String TIMEOUT_ERROR_MESSAGE = "Key retrieval exceeded the timeout limit.";
    private final MongoClient client;
    private final MongoNamespace namespace;

    KeyRetriever(MongoClient client, MongoNamespace namespace) {
        this.client = Assertions.notNull("client", client);
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    public List<BsonDocument> find(BsonDocument keyFilter, @Nullable Timeout operationTimeout) {
        MongoCollection<BsonDocument> collection = this.client.getDatabase(this.namespace.getDatabaseName()).getCollection(this.namespace.getCollectionName(), BsonDocument.class);
        return TimeoutHelper.collectionWithTimeout(collection, TIMEOUT_ERROR_MESSAGE, operationTimeout).withReadConcern(ReadConcern.MAJORITY).find(keyFilter).into(new ArrayList());
    }
}

